/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import journeymap.api.v2.common.event.CommonEventRegistry;
import journeymap.api.v2.common.event.common.WaypointEvent;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.ClientCategory;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ScrollListLayoutPane;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.buttons.SortButton;
import journeymap.client.ui.component.dropdown.ActionsDropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.waypointmanager.DeleteConfirmMultiSelectPopup;
import journeymap.client.ui.waypointmanager.DimensionsDropDownButton;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.client.ui.waypointmanager.group.GroupPanel;
import journeymap.client.ui.waypointmanager.group.GroupSettingsPopup;
import journeymap.client.ui.waypointmanager.group.GroupSlot;
import journeymap.client.ui.waypointmanager.notification.ImportExternalWaypointsScreen;
import journeymap.client.ui.waypointmanager.waypoint.WaypointEditor;
import journeymap.client.ui.waypointmanager.waypoint.WaypointPanel;
import journeymap.client.ui.waypointmanager.waypoint.WaypointSlot;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.JM;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.mixin.client.ScreenAccessor;
import journeymap.common.waypoint.GroupSettings;
import journeymap.common.waypoint.WaypointGroupImpl;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class WaypointManager
extends JmUI
implements SelectableParent {
    private final ClientWaypointImpl focusWaypoint;
    private Map<WaypointGroup, GroupSlot> groupMap;
    private GroupPanel<GroupSlot> groupPanel;
    private final WaypointGroup allGroup = WaypointGroupStore.getInstance().get(WaypointGroupStore.ALL.getGuid());
    private WaypointGroup selectedGroup = WaypointGroupStore.getInstance().get(WaypointGroupStore.ALL.getGuid());
    private class_8667 groupHeaderLayout;
    private class_8667 groupSortLayout;
    private class_8667 waypointSortLayout;
    private class_8667 waypointHeaderLayout;
    private class_8667 headerLayouts;
    private final Map<WaypointGroup, WaypointPanel<WaypointSlot>> panelMap = new HashMap<WaypointGroup, WaypointPanel<WaypointSlot>>();
    private DimensionsDropDownButton dimButton;
    private Button createGroupButton;
    private CheckBox selectAllCheckBox;
    private SortButton groupCountSortButton;
    private SortButton groupNameSortButton;
    private SortButton waypointDistanceSortButton;
    private SortButton waypointNameSortButton;
    private SearchTextBox searchTextBox;
    private int sidePanelSize = 130;
    private int panelYOffset = 40;
    private String lastSearch = "";
    private final Set<String> selectedWaypointGuids;
    private WorldData.DimensionProvider lastDim;
    private DropDownItem enableAll;

    public WaypointManager(class_437 returnDisplay) {
        this(null, returnDisplay);
    }

    public WaypointManager(ClientWaypointImpl focusWaypoint, class_437 returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), true, returnDisplay);
        this.field_22787 = class_310.method_1551();
        this.focusWaypoint = focusWaypoint;
        this.groupMap = this.buildGroupSlots();
        CommonEventRegistry.WAYPOINT_GROUP_EVENT.subscribe((Object)this, JM.MOD_ID, this::onWaypointGroupEvent);
        CommonEventRegistry.WAYPOINT_EVENT.subscribe((Object)this, JM.MOD_ID, this::onWaypointEvent);
        String lastSelected = WaypointGroupStore.getDisplaySetting("last_selected_group", "journeymap_default");
        this.selectedGroup = WaypointGroupStore.getInstance().get(lastSelected);
        this.selectedWaypointGuids = new HashSet<String>();
    }

    private void onWaypointGroupEvent(WaypointGroupEvent event) {
        if (!event.isCancelled()) {
            switch (event.getContext()) {
                case DELETED: {
                    GroupSlot group;
                    if (!WaypointGroupStore.isNative(event.getGroup())) {
                        WaypointGroupStore.getInstance().remove(event.getGroup(), event.deleteWaypoints());
                        GroupSlot defaultGroup = this.groupMap.get(WaypointGroupStore.getInstance().get(WaypointGroupStore.DEFAULT.getGuid()));
                        group = this.groupMap.getOrDefault(this.allGroup, defaultGroup);
                    } else {
                        group = this.groupMap.get(event.getGroup());
                        WaypointStore.getInstance().remove(event.getGroup());
                    }
                    this.updateSelectedGroup(group);
                    this.updateDimButton(group);
                    this.redrawSelectedWaypointSlots(group.getGroup());
                    this.updateGroupSlots();
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    this.addNewGroup(event.getGroup());
                }
            }
        }
    }

    private void onWaypointEvent(WaypointEvent event) {
        switch (event.getContext()) {
            case DELETED: {
                WaypointStore.getInstance().remove((ClientWaypointImpl)event.getWaypoint(), false);
                break;
            }
            case UPDATE: 
            case CREATE: {
                if (event.isCancelled()) break;
                WaypointStore.getInstance().save((ClientWaypointImpl)event.getWaypoint(), false, event.getContext() == WaypointEvent.Context.CREATE);
            }
        }
        this.updateGroupSlots();
        this.redrawSelectedWaypointSlots(this.selectedGroup);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        class_327 font = class_310.method_1551().field_1772;
        this.groupHeaderLayout = class_8667.method_52742();
        this.groupSortLayout = class_8667.method_52742();
        this.waypointHeaderLayout = class_8667.method_52742();
        this.waypointHeaderLayout.method_52735(3);
        this.groupHeaderLayout.method_52735(2);
        this.groupSortLayout.method_52735(2);
        this.waypointSortLayout = class_8667.method_52742();
        this.headerLayouts = class_8667.method_52742();
        this.headerLayouts.method_52738((class_8021)this.groupHeaderLayout, class_7847::method_46474);
        this.headerLayouts.method_52736((class_8021)this.waypointHeaderLayout);
        this.contentLayout.method_46441((class_8021)this.headerLayouts);
        this.contentLayout.method_46441((class_8021)this.groupSortLayout);
        this.contentLayout.method_46441((class_8021)this.waypointSortLayout);
        this.waypointSortLayout.method_52735(6);
        try {
            this.footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"jm.common.close"), b -> this.closeAndReturn()).method_46432(20 + font.method_27525((class_5348)class_2561.method_43471((String)"jm.common.close"))).method_46431());
            this.groupPanel = new GroupPanel(this.field_22787, this, 1, 36 + this.panelYOffset + 15, this.sidePanelSize - 1, this.field_22790 - 66 - 25, 20);
            this.groupPanel.setSlots(this.groupMap.values().stream().toList());
            this.groupPanel.initSlots();
            this.dimButton = new DimensionsDropDownButton(this::updateDimFilter);
            this.dimButton.setDefaultStyle(false);
            this.dimButton.setDrawBackground(false);
            this.dimButton.method_53533(15);
            this.dimButton.setRenderSolidBackground(true);
            this.dimButton.setButtonBuffer(40);
            this.groupSortLayout.method_52736((class_8021)new class_7852(20, 12));
            this.groupNameSortButton = (SortButton)this.groupSortLayout.method_52736((class_8021)new SortButton(Constants.getString("jm.waypoint.name"), "name", this.getGroupSortDir("name"), this::groupSort));
            this.groupSortLayout.method_52736((class_8021)new class_7852(0, 12));
            this.groupCountSortButton = (SortButton)this.groupSortLayout.method_52736((class_8021)new SortButton(Constants.getString("jm.waypoint.count"), "count", this.getGroupSortDir("count"), this::groupSort));
            this.groupHeaderLayout.method_52738((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"jm.waypoint.groups"), font), class_7847::method_46474);
            ((ImagePopupButton)this.groupHeaderLayout.method_52736(new ImagePopupButton<Boolean>(14, 14, TextureCache.OPTIONS_SPRITE, Constants.getString("jm.waypoint.group.edit_settings.title"), GroupSettingsPopup::new, this::onGroupSettings))).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.group.edit_settings.title")));
            this.createGroupButton = (Button)this.groupHeaderLayout.method_52738(new PopupButton<WaypointGroup>(0, 0, "+", () -> new EditGroupPopup((class_2561)class_2561.method_43471((String)"jm.waypoint.group.new_group.label")), this::addNewGroup), class_7847::method_46474);
            this.createGroupButton.method_25355((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1077));
            this.createGroupButton.method_55445(14, 14);
            this.createGroupButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.group.new_group.label")));
            this.selectAllCheckBox = new CheckBox(Constants.getString("jm.common.waypoint.select_all"), false, this::onSelectAll);
            this.selectAllCheckBox.setDrawText(false);
            this.selectAllCheckBox.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.common.waypoint.select_all.tooltip")));
            this.waypointSortLayout.method_52736((class_8021)this.selectAllCheckBox);
            this.waypointSortLayout.method_52736((class_8021)new class_7852(4, 4));
            this.waypointDistanceSortButton = (SortButton)this.waypointSortLayout.method_52736((class_8021)new SortButton(Constants.getString("jm.waypoint.distance"), "dist", this.getWaypointSortDir("dist"), this::waypointSort));
            this.waypointNameSortButton = (SortButton)this.waypointSortLayout.method_52736((class_8021)new SortButton(Constants.getString("jm.waypoint.name"), "name", this.getWaypointSortDir("name"), this::waypointSort));
            this.waypointHeaderLayout.method_52738((class_8021)new class_7842((class_2561)class_2561.method_43471((String)"jm.waypoint.waypoints"), font), class_7847::method_46474);
            this.searchTextBox = (SearchTextBox)this.waypointHeaderLayout.method_52738((class_8021)new SearchTextBox("", font, 70, 15), class_7847::method_46474);
            this.waypointHeaderLayout.method_52736((class_8021)this.dimButton);
            PopupButton createWaypoint = (PopupButton)this.waypointHeaderLayout.method_52738(new PopupButton<Waypoint>(0, 0, "+", () -> new WaypointEditor(false, null, this.selectedGroup), wp -> {}), class_7847::method_46474);
            createWaypoint.method_25355((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1077));
            createWaypoint.method_55445(14, 14);
            createWaypoint.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.new_title")));
            ((BasicImageButton)this.waypointHeaderLayout.method_52738((class_8021)new BasicImageButton(14, 14, TextureCache.OPTIONS_SPRITE, this::openWaypointOptions, (class_2561)class_2561.method_43471((String)"jm.waypoint.options.tooltip")), class_7847::method_46474)).method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.options.tooltip")));
            this.searchTextBox.method_1858(false);
            this.searchTextBox.setFillColor(0, 0.4f);
            this.searchTextBox.method_1863(this::updateSearch);
            this.method_37063((class_364)this.groupPanel);
            this.groupPanel.visitSlots(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
            });
            WaypointPanel<WaypointSlot> panel = this.getWaypointPanel(this.selectedGroup);
            this.method_37063((class_364)panel);
            panel.initSlots();
            panel.visitSlots(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
            });
            this.groupPanel.setSelected(WaypointGroupStore.getDisplaySetting("last_selected", this.allGroup.getGuid()));
            if (WaypointStore.getInstance().getExternalWaypoints().hasExternalWaypoints()) {
                PopupButton importButton = (PopupButton)this.waypointSortLayout.method_52736(new PopupButton<List>(0, 0, Constants.getString("jm.common.waypoint.notification.import"), () -> new ImportExternalWaypointsScreen((class_2561)class_2561.method_43471((String)"jm.common.waypoint.notification.import_external")), this::onImport));
                importButton.method_55445(font.method_27525((class_5348)class_2561.method_43471((String)"jm.common.waypoint.notification.import")) + 12, 12);
            }
            String actionsLabel = Constants.getString("jm.webmap.actions_title");
            ActionsDropDownButton actionsButton = new ActionsDropDownButton(actionsLabel, b -> {});
            actionsButton.method_53533(12);
            actionsButton.setItems(this.buildActionItems());
            this.waypointSortLayout.method_52738((class_8021)actionsButton, class_7847::method_46474);
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Error in WaypointManager.init(): {}", t);
        }
    }

    private ArrayList<DropDownItem> buildActionItems() {
        ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
        String enableKey = this.getEnabledComponent();
        this.enableAll = new DropDownItem((SelectableParent)this, (Object)"enable_all", Constants.getString(enableKey), this::onEnableAll, Constants.getString(enableKey + ".tooltip"));
        items.add(this.enableAll);
        items.add(new DropDownItem((SelectableParent)this, (Object)"toggle_selected", Constants.getString("jm.waypoint.toggle_selected"), this::onToggleSelected, "jm.waypoint.toggle_selected.tooltip"));
        items.add(new DropDownItem((SelectableParent)this, (Object)"delete_selected", Constants.getString("jm.waypoint.delete_selected.label"), this::onDeleteSelected, Constants.getString("jm.waypoint.delete_selected.tooltip")));
        return items;
    }

    private void onImport(List<ClientWaypointImpl> imported) {
        WaypointStore.getInstance().bulkAdd(imported);
        this.updateGroupSlots();
        this.redrawSelectedWaypointSlots(this.selectedGroup);
    }

    @Override
    protected void method_48640() {
        super.method_48640();
        this.headerLayouts.method_48229(5, 39);
        this.waypointHeaderLayout.method_46421(this.sidePanelSize + 5);
        this.groupSortLayout.method_48229(5, 58);
        this.waypointSortLayout.method_48229(this.sidePanelSize + 7, 58);
        this.groupPanel.updateSize(this.sidePanelSize - 1, this.field_22790 - 66 - this.panelYOffset, 1, 36 + this.panelYOffset);
        this.groupPanel.updateSlots();
        this.groupPanel.method_25307(0.0);
        this.groupPanel.repositionSlots();
        this.getWaypointPanel(this.selectedGroup).repositionSlots();
        this.panelMap.forEach((group, pane) -> {
            pane.updateSize(this.field_22789 - this.sidePanelSize - 4, this.field_22790 - 66 - this.panelYOffset, this.sidePanelSize + 2, 36 + this.panelYOffset);
            pane.updateSlots();
            pane.method_25307(0.0);
            pane.repositionSlots();
        });
        this.groupCountSortButton.setSorting("name".equals(WaypointGroupStore.getDisplaySetting("sort", "name")));
        this.groupNameSortButton.setSorting("count".equals(WaypointGroupStore.getDisplaySetting("sort", "name")));
        this.waypointDistanceSortButton.setSorting("dist".equals(((WaypointGroupImpl)this.selectedGroup).getSettings().getDisplaySetting("wp_sort", "name")));
        this.waypointNameSortButton.setSorting("name".equals(((WaypointGroupImpl)this.selectedGroup).getSettings().getDisplaySetting("wp_sort", "name")));
        this.updateDimButton(this.groupPanel.method_25334() == null ? this.groupMap.get(this.allGroup) : (GroupSlot)this.groupPanel.method_25334());
        this.redrawSelectedWaypointSlots(((GroupSlot)this.groupPanel.method_25334()).getGroup());
    }

    private int calculateEnableAllButtonX() {
        int scale = class_310.method_1551().method_22683().method_4486() / 100;
        int buttonAndGapSize = 12 + scale;
        int tpButton = CmdTeleportWaypoint.isPermitted(class_310.method_1551()) ? buttonAndGapSize : 1;
        int shareButton = JourneymapClient.getInstance().getWaypointProperties().disableShare.get() == false ? buttonAndGapSize : 1;
        int distWidth = 16 + scale + 40 + scale + 30 * scale - 1 + scale + tpButton + shareButton + buttonAndGapSize;
        return this.sidePanelSize + 5 + distWidth;
    }

    private void openWaypointOptions(class_4185 button) {
        ((ScreenAccessor)((Object)this)).setInitialized(false);
        UIManager.INSTANCE.openOptionsManager((class_437)this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon);
    }

    private void waypointSort(class_4185 button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        String dir = sortButton.getToggled() != false ? "asc" : "desc";
        WaypointGroupImpl group = (WaypointGroupImpl)this.selectedGroup;
        group.getSettings().setDisplaySetting("wp_sort", sortButton.getKey());
        group.getSettings().setDisplaySetting("wp_sort_type", dir);
        if ("name".equals(sortButton.getKey())) {
            this.waypointDistanceSortButton.setSorting(false);
            this.waypointNameSortButton.setSorting(true);
        } else {
            this.waypointNameSortButton.setSorting(false);
            this.waypointDistanceSortButton.setSorting(true);
        }
        this.redrawSelectedWaypointSlots(this.selectedGroup);
    }

    private void groupSort(class_4185 button) {
        SortButton sortButton = (SortButton)button;
        sortButton.toggle();
        String dir = sortButton.getToggled() != false ? "asc" : "desc";
        WaypointGroupStore.setDisplaySetting("sort", sortButton.getKey());
        WaypointGroupStore.setDisplaySetting("sort_type", dir);
        if ("name".equals(sortButton.getKey())) {
            this.groupCountSortButton.setSorting(false);
            this.groupNameSortButton.setSorting(true);
        } else {
            this.groupNameSortButton.setSorting(false);
            this.groupCountSortButton.setSorting(true);
        }
        this.updateGroupSlots();
    }

    private void updateSearch(String text) {
        if (!text.equals(this.lastSearch)) {
            this.lastSearch = text;
            this.redrawSelectedWaypointSlots(this.selectedGroup);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float par3) {
        GroupPanel<GroupSlot> panelUnderMouse;
        GroupSlot groupSlot;
        WaypointGroup group;
        super.method_25394(graphics, x, y, par3);
        this.outline(graphics, 0, 36, this.field_22789 - 1, this.field_22790 - 66);
        DrawUtil.drawRectangle(graphics, this.sidePanelSize, 36.0, 1.0, this.field_22790 - 66, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 56.0, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        DrawUtil.drawRectangle(graphics, 0.0, 71.0, this.field_22789 - 1, 1.0, 0xC0C0C0, 0.8f);
        Optional child = this.groupPanel.method_19355(x, y);
        List<WaypointSlot> draggingSlots = this.getWaypointPanel(this.selectedGroup).getDraggingSlots();
        if (draggingSlots != null && child.isPresent() && (group = (groupSlot = (GroupSlot)child.get()).getGroup()) != null) {
            boolean canTransfer = true;
            for (WaypointSlot slot2 : draggingSlots) {
                if (WaypointGroupStore.getInstance().canTransferWaypoint(group, slot2.getWaypoint())) continue;
                canTransfer = false;
                break;
            }
            groupSlot.renderTransferStatus(graphics, canTransfer);
        }
        ScrollListLayoutPane scrollListLayoutPane = child.isPresent() ? this.groupPanel : (panelUnderMouse = this.getWaypointPanel(this.selectedGroup).method_19355(x, y).isPresent() ? this.getWaypointPanel(this.selectedGroup) : null);
        if (panelUnderMouse != null) {
            List lastTooltip = panelUnderMouse.lastTooltip;
            long lastTooltipTime = panelUnderMouse.lastTooltipTime;
            if (panelUnderMouse.lastTooltip != null && panelUnderMouse.lastTooltip.equals(lastTooltip)) {
                panelUnderMouse.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - panelUnderMouse.lastTooltipTime > panelUnderMouse.hoverDelay) {
                    graphics.method_51447(this.field_22793, panelUnderMouse.lastTooltip, x, y + 15);
                }
            }
        }
        if (this.selectAllCheckBox.getToggled().booleanValue()) {
            List<WaypointSlot> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots();
            waypoints.forEach(slot -> {
                if (slot.isSelected() != this.selectAllCheckBox.getToggled().booleanValue()) {
                    this.selectAllCheckBox.setToggled(false);
                }
            });
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            boolean clicked = super.method_25402(mouseX, mouseY, button);
            if (button == 0) {
                Slot groupSelected = (Slot)this.groupPanel.method_25334();
                if (groupSelected != null && this.groupPanel.method_25405(mouseX, mouseY)) {
                    this.updateSelectedGroup(groupSelected);
                    this.updateDimButton((GroupSlot)groupSelected);
                    this.redrawSelectedWaypointSlots(((GroupSlot)groupSelected).getGroup());
                    WaypointGroupStore.setDisplaySetting("last_selected", ((GroupSlot)groupSelected).getGroup().getGuid());
                }
                this.getWaypointPanel(this.selectedGroup).method_25334();
            }
            return clicked;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        Optional child = this.groupPanel.method_19355(mouseX, mouseY);
        List<WaypointSlot> draggingSlots = this.getWaypointPanel(this.selectedGroup).getDraggingSlots();
        if (draggingSlots != null && child.isPresent()) {
            WaypointGroup groupTo = ((GroupSlot)child.get()).getGroup();
            HashSet<WaypointGroupImpl> groupSet = new HashSet<WaypointGroupImpl>();
            for (WaypointSlot slot : draggingSlots) {
                ClientWaypointImpl waypoint = slot.getWaypoint();
                WaypointGroupImpl groupFrom = WaypointGroupStore.getInstance().get(waypoint.getGroupId());
                if (!WaypointGroupStore.getInstance().canTransferWaypoint(groupTo, slot.getWaypoint())) continue;
                groupSet.add(groupFrom);
                groupTo.addWaypoint((Waypoint)waypoint);
            }
            if (!groupSet.isEmpty()) {
                this.updateGroupSlots();
                if (!this.allGroup.getGuid().equals(this.selectedGroup.getGuid())) {
                    groupSet.forEach(this::redrawSelectedWaypointSlots);
                }
            }
        }
        boolean groupMouseReleased = this.groupPanel.method_25406(mouseX, mouseY, button);
        String lastSelectedGroup = WaypointGroupStore.getDisplaySetting("last_selected_group", "journeymap_all");
        if (lastSelectedGroup != null) {
            this.groupPanel.select(lastSelectedGroup);
        }
        boolean waypointsMouseReleased = this.getWaypointPanel(this.selectedGroup).method_25406(mouseX, mouseY, button);
        return groupMouseReleased || waypointsMouseReleased;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.groupPanel.method_25403(mouseX, mouseY, button, dragX, dragY) || this.getWaypointPanel(this.selectedGroup).method_25403(mouseX, mouseY, button, dragX, dragY) || super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean groupScrolled = false;
        boolean waypointsScrolled = false;
        WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel(this.selectedGroup);
        if (this.groupPanel.method_25405(mouseX, mouseY)) {
            groupScrolled = this.groupPanel.method_25401(mouseX, mouseY, scrollX, scrollY);
        } else if (waypointPanel.method_25405(mouseX, mouseY)) {
            waypointsScrolled = this.getWaypointPanel(this.selectedGroup).method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return groupScrolled || waypointsScrolled;
    }

    public void updateSelectedGroup(Slot groupSelected) {
        this.cacheSelectedWaypoints();
        String lastSelectedGroup = ((GroupSlot)groupSelected).getGroup().getGuid();
        WaypointPanel<WaypointSlot> oldPanel = this.getWaypointPanel(this.selectedGroup);
        oldPanel.visitSlots(x$0 -> this.method_37066((class_364)x$0));
        this.groupPanel.unselect();
        this.method_37066((class_364)oldPanel);
        this.selectedGroup = ((GroupSlot)groupSelected).getGroup();
        WaypointPanel<WaypointSlot> newPanel = this.getWaypointPanel(this.selectedGroup);
        newPanel.setSlots(this.getWaypointsForGroup(this.selectedGroup));
        this.method_37063((class_364)newPanel);
        newPanel.initSlots();
        newPanel.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        this.groupPanel.select(lastSelectedGroup);
        WaypointGroupStore.setDisplaySetting("last_selected_group", lastSelectedGroup);
        this.updateSelectedWaypoints();
    }

    private void updateDimFilter(class_4185 button) {
        WorldData.DimensionProvider selected = (WorldData.DimensionProvider)((DropDownItem)button).getId();
        if (this.lastDim != selected) {
            this.clearSelections();
            this.lastDim = selected;
            String value = selected == null ? "all" : selected.getDimensionId();
            GroupSettings groupSettings = ((WaypointGroupImpl)this.selectedGroup).getSettings();
            String dimDisplay = groupSettings.getDisplaySettings().get("dimDisplay");
            if (dimDisplay == null || !dimDisplay.equals(value)) {
                groupSettings.setDisplaySetting("dimDisplay", value);
                WaypointGroupStore.getInstance().put(this.selectedGroup);
            }
            this.redrawSelectedWaypointSlots(this.selectedGroup);
        }
    }

    private void updateDimButton(GroupSlot groupSlot) {
        WaypointGroup group = this.allGroup;
        if (groupSlot != null) {
            group = groupSlot.getGroup();
        }
        String displayDim = ((WaypointGroupImpl)group).getSettings().getDisplaySettings().get("dimDisplay");
        if (JourneymapClient.getInstance().getWaypointProperties().managerDimensionFocus.get().booleanValue()) {
            displayDim = DimensionHelper.getDimKeyName((class_5321<class_1937>)this.field_22787.field_1724.method_37908().method_27983());
        }
        this.dimButton.setDim(displayDim == null || "all".equals(displayDim) ? null : displayDim);
    }

    protected Map<WaypointGroup, GroupSlot> buildGroupSlots() {
        WaypointGroupStore store = WaypointGroupStore.getInstance();
        LinkedHashMap<WaypointGroup, GroupSlot> map = new LinkedHashMap<WaypointGroup, GroupSlot>();
        boolean hideEmpty = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty", "false"));
        boolean hideAll = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_all", "false"));
        boolean hideEmptyDeath = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty_death", "false"));
        boolean hideEmptyTemp = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_empty_temp", "false"));
        List<WaypointGroup> sortedGroups = this.sortGroups(store.getAll());
        if (!hideAll) {
            map.put(store.get(this.allGroup.getGuid()), new GroupSlot(store.get(this.allGroup.getGuid()), this.field_22789, this.field_22790));
        }
        map.put(store.get(WaypointGroupStore.DEFAULT.getGuid()), new GroupSlot(store.get(WaypointGroupStore.DEFAULT.getGuid()), this.field_22789, this.field_22790));
        if (!(hideEmptyDeath && store.get(WaypointGroupStore.DEATH.getGuid()).getWaypointIds().isEmpty() || !JourneymapClient.getInstance().getStateHandler().isAllowDeathPoints())) {
            map.put(store.get(WaypointGroupStore.DEATH.getGuid()), new GroupSlot(store.get(WaypointGroupStore.DEATH.getGuid()), this.field_22789, this.field_22790));
        }
        if (!hideEmptyTemp || !store.get(WaypointGroupStore.TEMP.getGuid()).getWaypointIds().isEmpty()) {
            map.put(store.get(WaypointGroupStore.TEMP.getGuid()), new GroupSlot(store.get(WaypointGroupStore.TEMP.getGuid()), this.field_22789, this.field_22790));
        }
        sortedGroups.forEach(group -> {
            if (!(map.containsKey(group) || hideEmpty && group.getWaypointIds().isEmpty() || this.isNativeGroup((WaypointGroup)group))) {
                map.put((WaypointGroup)group, new GroupSlot((WaypointGroup)group, this.field_22789, this.field_22790));
            }
        });
        WaypointGroupStore.getInstance().bulkSave();
        return map;
    }

    private boolean isNativeGroup(WaypointGroup group) {
        return group.getGuid().equals(WaypointGroupStore.TEMP.getGuid()) || group.getGuid().equals(WaypointGroupStore.DEATH.getGuid()) || group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) || group.getGuid().equals(WaypointGroupStore.ALL.getGuid());
    }

    protected List<WaypointSlot> getWaypointsForGroup(WaypointGroup group) {
        String dim = ((WaypointGroupImpl)group).getSettings().getDisplaySetting("dimDisplay", "all");
        List<WaypointSlot> slots = "all".equals(dim) || dim == null ? group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().map(WaypointSlot::new).toList() : group.getWaypointIds().stream().map(id -> WaypointStore.getInstance().get((String)id)).toList().stream().filter(wp -> wp.getDimensions().contains(dim)).toList().stream().map(WaypointSlot::new).toList();
        if (!class_3544.method_15438((String)this.searchTextBox.method_1882())) {
            slots = slots.stream().filter(slot -> slot.getWaypoint().getName().toLowerCase().contains(this.searchTextBox.method_1882().toLowerCase())).toList();
        }
        if (!slots.isEmpty()) {
            return this.sortedWaypoints(slots);
        }
        return new ArrayList<WaypointSlot>();
    }

    private void addNewGroup(WaypointGroup group) {
        if (group != null) {
            WaypointGroupStore.getInstance().put(group);
            this.updateGroupSlots();
            this.redrawSelectedWaypointSlots(this.selectedGroup);
        }
    }

    public void updateGroupSlots() {
        this.groupMap = this.buildGroupSlots();
        this.groupPanel.visitSlots(x$0 -> this.method_37066((class_364)x$0));
        this.groupPanel.setSlots(this.groupMap.values().stream().toList());
        this.groupPanel.initSlots();
        this.groupPanel.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        String lastSelectedGroup = WaypointGroupStore.getDisplaySetting("last_selected_group", "journeymap_all");
        boolean hideall = Boolean.parseBoolean(WaypointGroupStore.getDisplaySetting("hide_all", "false"));
        this.groupPanel.select(lastSelectedGroup.equals(this.allGroup.getGuid()) && hideall ? WaypointGroupStore.DEFAULT.getGuid() : lastSelectedGroup);
    }

    private List<WaypointSlot> sortedWaypoints(List<WaypointSlot> list) {
        WaypointGroupImpl group = (WaypointGroupImpl)this.selectedGroup;
        String sort = group.getSettings().getDisplaySetting("wp_sort", "name");
        String sortDir = group.getSettings().getDisplaySetting("wp_sort_type", "asc");
        Comparator<WaypointSlot> comparator = switch (sort) {
            case "dist" -> Comparator.comparingInt(WaypointSlot::getDistance);
            default -> Comparator.comparing(g -> g.getWaypoint().getName().toLowerCase());
        };
        ArrayList<WaypointSlot> sorted = new ArrayList<WaypointSlot>(list);
        if (sortDir.equals("desc")) {
            sorted.sort(comparator.reversed());
        } else {
            sorted.sort(comparator);
        }
        return sorted;
    }

    private List<WaypointGroup> sortGroups(List<WaypointGroup> list) {
        String sort = WaypointGroupStore.getDisplaySetting("sort", "name");
        String sortDir = WaypointGroupStore.getDisplaySetting("sort_type", "asc");
        Comparator<WaypointGroup> comparator = switch (sort) {
            case "count" -> Comparator.comparingInt(g -> ((WaypointGroupImpl)g).count());
            default -> Comparator.comparing(g -> g.getName().toLowerCase());
        };
        ArrayList<WaypointGroup> sorted = new ArrayList<WaypointGroup>(list);
        if (sortDir.equals("desc")) {
            sorted.sort(comparator.reversed());
        } else {
            sorted.sort(comparator);
        }
        return sorted;
    }

    private boolean getGroupSortDir(String value) {
        String sort = WaypointGroupStore.getDisplaySetting("sort", "name");
        if (sort.equals(value)) {
            String sortDir = WaypointGroupStore.getDisplaySetting("sort_type", "asc");
            return sortDir.equals("asc");
        }
        return true;
    }

    private boolean getWaypointSortDir(String value) {
        WaypointGroupImpl group = (WaypointGroupImpl)this.selectedGroup;
        String sort = group.getSettings().getDisplaySetting("wp_sort", "name");
        if (sort.equals(value)) {
            String sortDir = group.getSettings().getDisplaySetting("wp_sort_type", "asc");
            return sortDir.equals("asc");
        }
        return true;
    }

    private void redrawSelectedWaypointSlots(WaypointGroup group) {
        WaypointPanel<WaypointSlot> waypointPanel = this.getWaypointPanel(this.selectedGroup);
        waypointPanel.visitSlots(x$0 -> this.method_37066((class_364)x$0));
        List<WaypointSlot> slots = this.getWaypointsForGroup(group);
        waypointPanel.setSlots(slots);
        waypointPanel.initSlots();
        waypointPanel.visitSlots(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_25429((class_364)x$0);
        });
        waypointPanel.updateSize(this.field_22789 - this.sidePanelSize - 4, this.field_22790 - 66 - this.panelYOffset, this.sidePanelSize + 2, 36 + this.panelYOffset);
        waypointPanel.updateSlots();
        waypointPanel.repositionSlots();
        this.updateSelectedWaypoints();
        this.updateEnabledButton();
    }

    private boolean isEnableAll() {
        if (this.selectedGroup.isEnabled()) {
            for (WaypointSlot slot : this.getWaypointPanel(this.selectedGroup).getRootSlots()) {
                if (slot.getWaypoint().isEnabled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getEnabledComponent() {
        return this.isEnableAll() ? "jm.waypoint.disable_waypoints" : "jm.waypoint.enable_waypoints";
    }

    private void updateEnabledButton() {
        String enableKey = this.getEnabledComponent();
        this.enableAll.method_25355((class_2561)class_2561.method_43471((String)enableKey));
        this.enableAll.setTooltip(Constants.getString(enableKey + ".tooltip"));
    }

    private void onEnableAll(class_4185 button) {
        WaypointGroup group = ((GroupSlot)this.groupPanel.method_25334()).getGroup();
        List<ClientWaypointImpl> waypoints = this.getWaypointsForGroup(group).stream().map(WaypointSlot::getWaypoint).toList();
        if (!waypoints.isEmpty() && (group.isEnabled() || this.allGroup.getGuid().equals(group.getGuid()))) {
            WaypointStore.getInstance().toggleWaypoints(waypoints, !this.isEnableAll());
            this.redrawSelectedWaypointSlots(group);
        }
    }

    private void onToggleSelected(class_4185 button) {
        List<ClientWaypointImpl> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots().stream().filter(WaypointSlot::isSelected).map(WaypointSlot::getWaypoint).toList();
        if (!waypoints.isEmpty() && (this.selectedGroup.isEnabled() || this.allGroup.getGuid().equals(this.selectedGroup.getGuid()))) {
            WaypointStore.getInstance().toggleWaypoints(waypoints);
            this.redrawSelectedWaypointSlots(this.selectedGroup);
        }
    }

    private void onDeleteSelected(class_4185 button) {
        List<ClientWaypointImpl> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots().stream().filter(WaypointSlot::isSelected).map(WaypointSlot::getWaypoint).toList();
        if (!waypoints.isEmpty() && (this.selectedGroup.isEnabled() || this.allGroup.getGuid().equals(this.selectedGroup.getGuid()))) {
            DeleteConfirmMultiSelectPopup delete = new DeleteConfirmMultiSelectPopup(waypoints.size());
            delete.setOnClosed(doDelete -> {
                if (doDelete.booleanValue()) {
                    waypoints.forEach(wp -> WaypointStore.getInstance().remove((ClientWaypointImpl)wp, true));
                    this.updateSelectedGroup(this.groupMap.get(this.selectedGroup));
                    this.redrawSelectedWaypointSlots(this.selectedGroup);
                    this.updateGroupSlots();
                }
            });
            delete.display();
        }
    }

    private WaypointPanel<WaypointSlot> getWaypointPanel(WaypointGroup group) {
        WaypointPanel<WaypointSlot> panel = this.panelMap.get(group);
        if (panel == null) {
            panel = new WaypointPanel(this.field_22787, this.sidePanelSize + 4, 36 + this.panelYOffset, this.field_22789 - this.sidePanelSize - 1, this.field_22790 - 66 - 25, 20);
            panel.setSlots(this.getWaypointsForGroup(group));
            this.panelMap.put(group, panel);
        }
        return panel;
    }

    public boolean isSearchFocused() {
        return this.searchTextBox.method_25370();
    }

    public void method_25419() {
        WaypointStore.getInstance().bulkSave();
        WaypointGroupStore.getInstance().bulkSave();
        CommonEventRegistry.WAYPOINT_GROUP_EVENT.unsubscribe((Object)this, JM.MOD_ID);
        CommonEventRegistry.WAYPOINT_EVENT.unsubscribe((Object)this, JM.MOD_ID);
        super.method_25419();
    }

    private void onSelectAll(class_4185 button) {
        Boolean toggled = ((CheckBox)button).getToggled();
        List<WaypointSlot> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots();
        waypoints.forEach(slot -> slot.setSelected(toggled));
        this.cacheSelectedWaypoints();
    }

    private void clearSelections() {
        this.selectAllCheckBox.setToggled(false);
        this.selectedWaypointGuids.clear();
        List<WaypointSlot> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots();
        waypoints.forEach(slot -> slot.setSelected(false));
    }

    private void cacheSelectedWaypoints() {
        this.selectedWaypointGuids.clear();
        List<WaypointSlot> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots();
        waypoints.forEach(slot -> {
            if (slot.isSelected()) {
                this.selectedWaypointGuids.add(slot.getWaypoint().getGuid());
            }
        });
    }

    private void updateSelectedWaypoints() {
        List<WaypointSlot> waypoints = this.getWaypointPanel(this.selectedGroup).getRootSlots();
        waypoints.forEach(slot -> {
            String guid = slot.getWaypoint().getGuid();
            if (this.selectedWaypointGuids.contains(guid)) {
                slot.setSelected(true);
            }
        });
    }

    @Override
    public void setSelected(DropDownItem button) {
        button.press();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            this.method_25419();
        } else {
            UIManager.INSTANCE.open((class_437)returnDisplayStack.pop());
        }
    }

    private void onGroupSettings(boolean edited) {
        if (edited) {
            this.updateGroupSlots();
        }
    }
}

