/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import com.google.common.base.MoreObjects;
import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import journeymap.common.Journeymap;
import journeymap.common.network.model.Location;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class TeleportPacket
implements Location {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"journeymap", (String)"teleport_req");
    public static final class_9139<class_9129, TeleportPacket> STREAM_CODEC = class_9139.method_56438(TeleportPacket::encode, TeleportPacket::new);
    private double x;
    private double y;
    private double z;
    private String dim;

    public TeleportPacket() {
    }

    public TeleportPacket(double x, double y, double z, String dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public TeleportPacket(class_9129 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.x = buf.readDouble();
                this.y = buf.readDouble();
                this.z = buf.readDouble();
                this.dim = buf.method_10800(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for teleport packet: %s", t));
        }
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public String getDim() {
        return this.dim;
    }

    public void encode(class_9129 buf) {
        try {
            buf.method_52940(this.x);
            buf.method_52940(this.y);
            buf.method_52940(this.z);
            buf.method_10814(this.dim);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for teleport packet:" + String.valueOf(t));
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("x", this.x).add("y", this.y).add("z", this.z).add("dim", (Object)this.dim).toString();
    }

    public static void handle(PacketContext<TeleportPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().handleTeleportPacket(ctx.sender(), (Location)ctx.message());
        }
    }
}

