/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.google.common.base.Joiner;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.command.JMCommand;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.Strings;

public class ClientCommandInvoker
implements JMCommand {
    public static final String BASE = "jmc";
    public static final String BASE_COMMAND = "/jmc";
    public static final String BASE_COMMAND_SPACED = "/jmc ";
    Map<String, JMCommand> commandMap = new HashMap<String, JMCommand>();

    public ClientCommandInvoker registerSub(JMCommand command) {
        this.commandMap.put(command.getName().toLowerCase(), command);
        return this;
    }

    @Override
    public String getName() {
        return BASE;
    }

    @Override
    public String getUsage(LocalPlayer sender) {
        StringBuffer sb = new StringBuffer();
        for (JMCommand command : this.commandMap.values()) {
            String usage = command.getUsage(sender);
            if (Strings.isEmpty((CharSequence)usage)) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(BASE_COMMAND_SPACED).append(usage);
        }
        return sb.toString();
    }

    @Override
    public int execute(LocalPlayer sender, String[] args) throws CommandSyntaxException {
        try {
            if (args.length > 0) {
                JMCommand command = this.getSubCommand(args);
                if (command != null) {
                    String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                    command.execute(sender, subArgs);
                }
            } else {
                Minecraft.getInstance().gui.getChat().addMessage((Component)Constants.getStringTextComponent(this.getUsage(sender)));
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toPartialString(t));
            this.exception("Error in /jmc ", t);
        }
        return 0;
    }

    public JMCommand getSubCommand(String[] args) {
        JMCommand command;
        if (args.length > 0 && (command = this.commandMap.get(args[0].toLowerCase())) != null) {
            return command;
        }
        return null;
    }

    public String getPossibleCommands() {
        return Joiner.on((String)",").join(this.commandMap.keySet());
    }
}

