/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.command;

import com.google.common.base.Joiner;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.JourneymapClient;
import journeymap.client.command.JMCommand;
import journeymap.client.log.ChatLog;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.ui.UIManager;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.client.waypoint.WaypointParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;

public class CmdEditWaypoint
implements JMCommand {
    public static final String COMMAND = "/jmc wpedit ";

    @Override
    public String getName() {
        return "wpedit";
    }

    @Override
    public int execute(LocalPlayer sender, String[] args) throws CommandSyntaxException {
        String text = Joiner.on((String)" ").skipNulls().join((Object[])args);
        Waypoint wp = WaypointParser.parse(text);
        final ClientWaypointImpl holder = new ClientWaypointImpl(wp);
        if (holder != null) {
            final boolean controlDown = InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)341) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)345);
            JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

                @Override
                public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
                    if (controlDown) {
                        if (holder.isInPlayerDimension()) {
                            holder.setPersistent(false);
                            UIManager.INSTANCE.openFullscreenMap(holder);
                        } else {
                            ChatLog.announceError("Location is not in your dimension");
                        }
                    } else {
                        UIManager.INSTANCE.openWaypointEditor(holder, true);
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return "Edit Waypoint";
                }
            });
        } else {
            ChatLog.announceError("Not a valid waypoint. Use: 'x:3, z:70', etc. : " + text);
        }
        return 0;
    }

    @Override
    public String getUsage(LocalPlayer sender) {
        return null;
    }
}

