/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.entity.EntityDTO;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(Minecraft mc, Player player) {
        int posX = Mth.floor((double)player.getX());
        int posY = Mth.floor((double)player.getEyeY());
        int posZ = Mth.floor((double)player.getZ());
        boolean offset = true;
        boolean isUnderground = false;
        if (posY < player.level().getMinY()) {
            return true;
        }
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(ChunkPos.asLong((int)(x >> 4), (int)(z >> 4)));
                if (chunkMD == null) continue;
                if (chunkMD.ceiling(x & 0xF, z & 0xF) <= posY + JourneymapClient.getInstance().getCoreProperties().caveModeThreshold.get()) {
                    isUnderground = false;
                    break block0;
                }
                isUnderground = true;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
        dto.update((LivingEntity)player, false);
        dto.biome = this.getPlayerBiome((Player)player);
        dto.underground = PlayerData.playerIsUnderground(mc, (Player)player);
        return dto;
    }

    private String getPlayerBiome(Player player) {
        if (player != null) {
            try {
                Biome biome = (Biome)Minecraft.getInstance().level.getBiome(player.blockPosition()).value();
                if (biome != null) {
                    return BiomeHelper.getTranslatedBiomeName(biome);
                }
            }
            catch (Exception e) {
                JMLogger.throwLogOnce("Couldn't get player biome: " + e.getMessage(), e);
            }
        }
        return "?";
    }

    public long getTTL() {
        return JourneymapClient.getInstance().getCoreProperties().cachePlayerData.get().intValue();
    }
}

