/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import journeymap.client.JourneymapClientForge;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.event.ForgeEvents;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraftforge.eventbus.api.bus.BusGroup;

public class ForgeEventHandlerManager {
    private static HashMap<Class<? extends EventHandler>, EventHandler> handlers = new HashMap();

    public static void registerHandlers() {
        ForgeEventHandlerManager.register(JourneymapClientForge.getInstance().getKeyEvents());
        ForgeEventHandlerManager.register(new ForgeEvents());
        ColorManager.INSTANCE.getDeclaringClass();
    }

    public static void unregisterAll() {
        ArrayList<Class<? extends EventHandler>> list = new ArrayList<Class<? extends EventHandler>>(handlers.keySet());
        for (Class<? extends EventHandler> handlerClass : list) {
            ForgeEventHandlerManager.unregister(handlerClass);
        }
    }

    public static void register(EventHandler handler) {
        Class<?> handlerClass = handler.getClass();
        if (handlers.containsKey(handlerClass)) {
            Journeymap.getLogger().warn("Handler already registered: " + handlerClass.getName());
            return;
        }
        try {
            BusGroup.DEFAULT.register(MethodHandles.lookup(), (Object)handler);
            Journeymap.getLogger().debug("Handler registered: " + handlerClass.getName());
            handlers.put(handler.getClass(), handler);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(handlerClass.getName() + " registration FAILED: " + LogFormatter.toString(t));
        }
    }

    public static void unregister(Class<? extends EventHandler> handlerClass) {
        EventHandler handler = handlers.remove(handlerClass);
        if (handler != null) {
            try {
                Journeymap.getLogger().debug("Handler unregistered: " + handlerClass.getName());
            }
            catch (Throwable t) {
                Journeymap.getLogger().error(String.valueOf(handler) + " unregistration FAILED: " + LogFormatter.toString(t));
            }
        }
    }

    public static HashMap<Class<? extends EventHandler>, EventHandler> getHandlers() {
        return handlers;
    }

    public static interface EventHandler {
    }
}

