/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.event.ForgeEventHandlerManager;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyEvent;
import journeymap.common.Journeymap;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

@ParametersAreNonnullByDefault
public class ForgeKeyEvents
implements KeyEvent,
ForgeEventHandlerManager.EventHandler {
    private static final List<KeyMapping> keyList = Lists.newArrayList();
    private final KeyEventHandler keyEventHandler = new KeyEventHandler(this);

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.Key event) {
        int key = event.getKey();
        this.keyEventHandler.onGameKeyboardEvent(key);
    }

    @SubscribeEvent
    public boolean onGuiKeyboardEvent(ScreenEvent.KeyPressed.Post event) {
        int key = event.getKeyCode();
        return this.keyEventHandler.onGuiKeyboardEvent(event.getScreen(), key);
    }

    @SubscribeEvent
    public void onGuiMouseEvent(ScreenEvent.MouseButtonPressed.Post event) {
        int key = event.getButton();
        this.keyEventHandler.onMouseEvent(event.getScreen(), event.getInfo().buttonInfo(), 1);
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseButton.Post event) {
        if (Minecraft.getInstance().screen == null) {
            int key = event.getButton();
            this.keyEventHandler.onMouseEvent(null, event.getInfo(), event.getAction());
        }
    }

    @Override
    public KeyEventHandler getHandler() {
        return this.keyEventHandler;
    }

    @Override
    public KeyMapping register(KeyMapping keyMapping) {
        keyList.add(keyMapping);
        return keyMapping;
    }

    @SubscribeEvent
    public static void onKeyRegisterEvent(RegisterKeyMappingsEvent event) {
        Journeymap.getLogger().info("Registering Keybinds");
        keyList.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }
}

