/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers.keymapping;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import journeymap.client.event.handlers.keymapping.KeyConflictContext;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;

public enum KeyModifier {
    CONTROL(KeyModifier::hasControlDown),
    SHIFT(KeyModifier::hasShiftDown),
    ALT(KeyModifier::hasAltDown),
    NONE(() -> !KeyModifier.hasControlDown() && !KeyModifier.hasControlDown() && !KeyModifier.hasAltDown());

    final Func isActive;

    private KeyModifier(Func isActive) {
        this.isActive = isActive;
    }

    public boolean isActive(KeyConflictContext context) {
        return this.isActive.isActive();
    }

    public static boolean hasControlDown() {
        return Util.getPlatform() == Util.OS.OSX ? InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)343) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)347) : InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)341) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)345);
    }

    public static boolean hasShiftDown() {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
    }

    public static boolean hasAltDown() {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)342) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)346);
    }

    public static boolean isCut(int keyCode) {
        return keyCode == 88 && KeyModifier.hasControlDown() && !KeyModifier.hasShiftDown() && !KeyModifier.hasAltDown();
    }

    public static boolean isPaste(int keyCode) {
        return keyCode == 86 && KeyModifier.hasControlDown() && !KeyModifier.hasShiftDown() && !KeyModifier.hasAltDown();
    }

    public static boolean isCopy(int keyCode) {
        return keyCode == 67 && KeyModifier.hasControlDown() && !KeyModifier.hasShiftDown() && !KeyModifier.hasAltDown();
    }

    public static boolean isSelectAll(int keyCode) {
        return keyCode == 65 && KeyModifier.hasControlDown() && !KeyModifier.hasShiftDown() && !KeyModifier.hasAltDown();
    }

    static interface Func {
        public boolean isActive();
    }
}

