/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.level.ChunkPos;

public class RegionMipmapGenerator {
    private static final float[] GAMMA_POW_2_2 = new float[256];

    public static NativeImage[] generateMipmaps(NativeImage baseImage, int mipmapLevel) {
        NativeImage[] mipmaps = new NativeImage[mipmapLevel + 1];
        mipmaps[0] = baseImage;
        for (int i = 1; i <= mipmapLevel; ++i) {
            NativeImage image = mipmaps[i - 1];
            NativeImage nextImage = new NativeImage(image.getWidth() >> 1, image.getHeight() >> 1, false);
            int width = nextImage.getWidth();
            int height = nextImage.getHeight();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    nextImage.setPixel(x, y, RegionMipmapGenerator.alphaBlend(image.getPixel(x * 2 + 0, y * 2 + 0), image.getPixel(x * 2 + 1, y * 2 + 0), image.getPixel(x * 2 + 0, y * 2 + 1), image.getPixel(x * 2 + 1, y * 2 + 1)));
                }
            }
            mipmaps[i] = nextImage;
        }
        return mipmaps;
    }

    public static void updateMipmapsAndUpload(NativeImage[] mipmaps, Set<ChunkPos> dirtyChunks, GpuTexture texture) {
        HashSet<ChunkPos> dirtyChunksPrev = new HashSet<ChunkPos>(dirtyChunks);
        int chunkSize = 16;
        for (int i = 1; i < mipmaps.length; ++i) {
            HashSet<ChunkPos> dirtyChunksScaled = new HashSet<ChunkPos>();
            for (ChunkPos pos : dirtyChunksPrev) {
                dirtyChunksScaled.add(new ChunkPos(pos.x >> 1, pos.z >> 1));
            }
            dirtyChunksPrev = dirtyChunksScaled;
            NativeImage image = mipmaps[i - 1];
            NativeImage nextImage = mipmaps[i];
            chunkSize = Math.max(chunkSize >> 1, 1);
            for (ChunkPos pos : dirtyChunksScaled) {
                for (int x = pos.x; x < pos.x + chunkSize; ++x) {
                    for (int y = pos.z; y < pos.z + chunkSize; ++y) {
                        nextImage.setPixel(x, y, RegionMipmapGenerator.alphaBlend(image.getPixel(x * 2 + 0, y * 2 + 0), image.getPixel(x * 2 + 1, y * 2 + 0), image.getPixel(x * 2 + 0, y * 2 + 1), image.getPixel(x * 2 + 1, y * 2 + 1)));
                    }
                }
                RenderSystem.getDevice().createCommandEncoder().writeToTexture(texture, nextImage, i, 0, pos.x, pos.z, chunkSize, chunkSize, pos.x, pos.z);
            }
            mipmaps[i] = nextImage;
        }
    }

    private static int alphaBlend(int color1, int color2, int color3, int color4) {
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        int count = 0;
        if (color1 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color1 >> 0);
            g += RegionMipmapGenerator.getPow22(color1 >> 8);
            b += RegionMipmapGenerator.getPow22(color1 >> 16);
            ++count;
        }
        if (color2 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color2 >> 0);
            g += RegionMipmapGenerator.getPow22(color2 >> 8);
            b += RegionMipmapGenerator.getPow22(color2 >> 16);
            ++count;
        }
        if (color3 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color3 >> 0);
            g += RegionMipmapGenerator.getPow22(color3 >> 8);
            b += RegionMipmapGenerator.getPow22(color3 >> 16);
            ++count;
        }
        if (color4 >> 24 != 0) {
            r += RegionMipmapGenerator.getPow22(color4 >> 0);
            g += RegionMipmapGenerator.getPow22(color4 >> 8);
            b += RegionMipmapGenerator.getPow22(color4 >> 16);
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        int r2 = (int)(Math.pow(r /= (float)count, 0.45454545454545453) * 255.0);
        int g2 = (int)(Math.pow(g /= (float)count, 0.45454545454545453) * 255.0);
        int b2 = (int)(Math.pow(b /= (float)count, 0.45454545454545453) * 255.0);
        return 0xFF000000 | b2 << 16 | g2 << 8 | r2;
    }

    private static float getPow22(int value) {
        return GAMMA_POW_2_2[value & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RegionMipmapGenerator.GAMMA_POW_2_2[i] = (float)Math.pow((float)i / 255.0f, 2.2);
        }
    }
}

