/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.util.FormattedCharSequence;

public class ScrollListPane<T extends Slot>
extends ObjectSelectionList<Slot<T>> {
    public SlotMetadata lastTooltipMetadata;
    public List<FormattedCharSequence> lastTooltip;
    public long lastTooltipTime;
    public long hoverDelay = 400L;
    protected int hpad = 12;
    private List<T> rootSlots;
    private SlotMetadata lastPressed;
    protected int lastClickedIndex;
    protected int scrollbarX;
    protected int listWidth;
    private boolean alignTop;

    public ScrollListPane(Minecraft mc, int x, int y, int width, int height, int slotHeight) {
        super(mc, y, width, height, slotHeight);
        this.updateSize(width, height, x, y);
    }

    public void updateSize(int width, int height, int x, int y) {
        super.updateSizeAndPosition(width, height, x, y);
        this.scrollbarX = this.width - this.hpad;
        this.listWidth = this.width - this.hpad * 4;
    }

    public void setListWidth(int width) {
        this.scrollbarX = (this.width + width) / 2 - this.hpad;
        this.listWidth = width - this.hpad * 4;
    }

    public void setSlots(List<T> slots) {
        this.rootSlots = slots;
        this.updateSlots();
    }

    public List<T> getRootSlots() {
        return this.rootSlots;
    }

    public void updateSlots() {
        int sizeBefore = this.getItemCount();
        this.clearEntries();
        int columnWidth = 0;
        for (Slot slot : this.rootSlots) {
            columnWidth = Math.max(columnWidth, slot.getColumnWidth());
            super.addEntry((AbstractSelectionList.Entry)slot);
            List childSlots = slot.getChildSlots(this.listWidth, columnWidth);
            if (childSlots == null || childSlots.isEmpty()) continue;
            for (Slot child : childSlots) {
                super.addEntry(child);
            }
        }
        int sizeAfter = this.getItemCount();
        if (sizeBefore < sizeAfter) {
            this.scroll(-(sizeAfter * this.getItemHeight()));
            this.scroll(this.lastClickedIndex * this.getItemHeight());
        }
    }

    public void scrollTo(Slot slot) {
        this.scroll(-(this.children().size() * this.getItemHeight()));
        this.scroll(this.children().indexOf((Object)slot) * this.getItemHeight());
    }

    public boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.children().get(index));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack pose = new PoseStack();
        try {
            Slot slot = (Slot)this.getEntryAtPosition(mouseX, mouseY);
            if (slot != null) {
                SlotMetadata tooltipMetadata = slot.getCurrentTooltip(mouseX, mouseY);
                if (tooltipMetadata != null && !tooltipMetadata.getTooltip().equals(this.lastTooltip)) {
                    this.lastTooltipMetadata = tooltipMetadata;
                    this.lastTooltip = tooltipMetadata.getTooltip();
                    this.lastTooltipTime = System.currentTimeMillis();
                }
                if (tooltipMetadata == null) {
                    this.lastTooltip = null;
                    this.lastTooltipMetadata = null;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.renderBackground(graphics, pose, mouseX, mouseY, partialTicks);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderSelection(GuiGraphics guiGraphics, Slot<T> entry, int color) {
        int top = entry.getContentY();
        int i = this.getX() + (this.width - entry.getWidth()) / 2;
        int j = this.getX() + (this.width + entry.getWidth()) / 2 - 8;
        guiGraphics.fill(i, top - 2, j + 4, top + entry.getHeight() - 2, color);
        guiGraphics.fill(i + 1, top - 1, j + 3, top + entry.getHeight() - 3, -16777216);
    }

    protected void renderListSeparators(GuiGraphics graphics) {
    }

    protected void enableScissor(GuiGraphics graphics) {
        super.enableScissor(graphics);
    }

    protected void renderListBackground(GuiGraphics graphics) {
    }

    public void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderListItems(graphics, mouseX, mouseY, partialTicks);
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean clicked = false;
        if (this.isMouseOver(event.x(), event.y())) {
            clicked = super.mouseClicked(event, doubleClick);
            Slot slot = (Slot)this.getEntryAtPosition(event.x(), event.y());
            if (slot == null) {
                return clicked;
            }
            this.lastClickedIndex = this.children().indexOf((Object)slot);
            this.lastPressed = slot.getLastPressed();
            if (slot instanceof CategorySlot) {
                this.updateSlots();
            }
        }
        return clicked;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (int slotIndex = 0; slotIndex < this.getItemCount(); ++slotIndex) {
            Slot slot;
            if (slotIndex != this.lastClickedIndex || !(slot = this.getSlot(this.lastClickedIndex)).mouseReleased(event)) continue;
            this.lastPressed = null;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent event, double mouseDX, double mouseDY) {
        if (this.children().isEmpty()) {
            return false;
        }
        if (this.lastClickedIndex > -1 && this.getSlot(this.lastClickedIndex) != null && this.getSlot(this.lastClickedIndex).mouseDragged(event, mouseDX, mouseDY)) {
            return true;
        }
        return super.mouseDragged(event, mouseDX, mouseDY);
    }

    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        if (this.getItemCount() == 0) {
            return null;
        }
        if (focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation) {
            ComponentPath path;
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent;
            Slot focused = (Slot)this.getFocused();
            if (arrowNavigation.direction().getAxis() == ScreenAxis.HORIZONTAL && focused != null) {
                return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)focused.nextFocusPath(focusNavigationEvent));
            }
            int index = -1;
            ScreenDirection direction = arrowNavigation.direction();
            if (this.isFocused() && focused != null) {
                index = focused.children().indexOf(focused.getFocused());
            }
            if (index == -1) {
                switch (direction) {
                    case LEFT: {
                        index = Integer.MAX_VALUE;
                        direction = ScreenDirection.DOWN;
                        break;
                    }
                    case RIGHT: {
                        index = 0;
                        direction = ScreenDirection.DOWN;
                        break;
                    }
                    default: {
                        index = 0;
                    }
                }
            }
            do {
                if ((focused = (Slot)this.nextEntry(direction, s -> true, (AbstractSelectionList.Entry)focused)) != null) continue;
                return null;
            } while ((path = focused.children().isEmpty() ? ComponentPath.leaf((GuiEventListener)focused) : focused.focusPathAtIndex((FocusNavigationEvent)arrowNavigation, index)) == null);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }
        if (!this.isFocused() && focusNavigationEvent instanceof FocusNavigationEvent.TabNavigation) {
            FocusNavigationEvent.TabNavigation tabNavigation = (FocusNavigationEvent.TabNavigation)focusNavigationEvent;
            Slot selected = (Slot)this.getSelected();
            if (selected == null) {
                selected = this.getSlot(0);
            }
            ComponentPath path = selected.children().isEmpty() ? ComponentPath.leaf((GuiEventListener)selected) : selected.focusPathAtIndex((FocusNavigationEvent)tabNavigation, 0);
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path);
        }
        return null;
    }

    public Slot getSlot(int index) {
        if (super.getItemCount() > index) {
            return (Slot)((Object)this.children().get(index));
        }
        return null;
    }

    public SlotMetadata getLastPressed() {
        return this.lastPressed;
    }

    public void resetLastPressed() {
        this.lastPressed = null;
    }

    public Slot getLastPressedParentSlot() {
        if (this.lastPressed != null) {
            for (Slot slot : this.rootSlots) {
                if (!slot.contains(this.lastPressed)) continue;
                return slot;
            }
        }
        return null;
    }

    public boolean charTyped(CharacterEvent event) {
        for (int slotIndex = 0; slotIndex < this.getItemCount(); ++slotIndex) {
            if (slotIndex != this.lastClickedIndex) continue;
            return this.getSlot(this.lastClickedIndex).charTyped(event);
        }
        return false;
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.getSelected() != null) {
            return ((Slot)this.getSelected()).keyPressed(event);
        }
        return false;
    }

    protected int scrollBarX() {
        return this.scrollbarX;
    }

    protected void renderBackground(GuiGraphics graphics, PoseStack poseStack, int i, int j, float f) {
        graphics.fillGradient(0, this.getY(), this.width, this.height + this.getY(), -1072689136, -804253680);
    }

    protected int contentHeight() {
        int contentHeight = super.contentHeight();
        if (this.alignTop) {
            contentHeight = Math.max(this.getBottom() - this.getTop() - 4, contentHeight);
        }
        return contentHeight;
    }

    public int getTop() {
        return super.getY();
    }

    public int getHeight() {
        return this.height;
    }

    public void setAlignTop(boolean alignTop) {
        this.alignTop = alignTop;
    }

    public int getItemHeight() {
        return this.defaultEntryHeight;
    }

    protected T getEntry(int index) {
        return (T)((Object)((Slot)((Object)this.children().get(index))));
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

