/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import journeymap.client.Constants;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.mixin.client.EditBoxAccessor;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SearchTextBox
extends EditBox {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/text_field"), ResourceLocation.withDefaultNamespace((String)"widget/text_field_highlighted"));
    private final String initialValue;
    private int fillColor = -16777216;
    private boolean drawBackground = true;

    public SearchTextBox(String value, Font fontRenderer, int width, int height) {
        super(fontRenderer, 0, 0, width + 15, height, (Component)Constants.getStringTextComponent(value == null ? "" : value.toString()));
        this.initialValue = value;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean clicked = super.mouseClicked(event, doubleClick);
        if (clicked && this.initialValue.contains(this.getValue())) {
            this.selectAll();
        }
        return clicked;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            if (this.isBordered()) {
                ResourceLocation resourcelocation = SPRITES.get(this.isActive(), this.isFocused());
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, resourcelocation, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            } else if (this.isDrawBackground()) {
                graphics.fill(this.getX() + 1, this.getY() + 1, this.getWidth() + this.getX() - 1, this.getHeight() + this.getY() - 1, this.fillColor);
            }
            int l1 = ((EditBoxAccessor)((Object)this)).isEditable() ? ((EditBoxAccessor)((Object)this)).getTextColor() : ((EditBoxAccessor)((Object)this)).getUneditableTextColor();
            int i = this.getCursorPosition() - this.displayPos;
            String s = this.font.plainSubstrByWidth(this.getValue().substring(this.displayPos), this.getInnerWidth());
            boolean flag = i >= 0 && i <= s.length();
            boolean flag1 = this.isFocused() && (Util.getMillis() - ((EditBoxAccessor)((Object)this)).getFocusTime()) / 300L % 2L == 0L && flag;
            int j = this.getX() + 4 + 15;
            int k = this.getY() + (this.height - 8) / 2;
            int l = j;
            int i1 = Mth.clamp((int)(((EditBoxAccessor)((Object)this)).getHighlightPos() - this.displayPos), (int)0, (int)s.length());
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, i) : s;
                FormattedCharSequence formattedcharsequence = ((EditBoxAccessor)((Object)this)).invokeApplyFormat(s1, this.displayPos);
                graphics.drawString(this.font, formattedcharsequence, j, k, l1);
                l += this.font.width(formattedcharsequence) + 1;
            }
            int iconColor = this.isFocused() ? 0xFFFFFF : 0x808080;
            DrawUtil.drawTexture(graphics, TextureCache.SearchIcon, iconColor, 1.0f, (double)(j - 15), (double)(k - 1), 11.0, 11.0, false, 0.0);
            boolean flag2 = this.getCursorPosition() < this.getValue().length() || this.getValue().length() >= ((EditBoxAccessor)((Object)this)).maxLength();
            int j1 = l;
            if (!flag) {
                j1 = i > 0 ? j + this.width : j;
            } else if (flag2) {
                j1 = l - 1;
                --l;
            }
            if (!s.isEmpty() && flag && i < s.length()) {
                graphics.drawString(this.font, ((EditBoxAccessor)((Object)this)).invokeApplyFormat(s.substring(i), this.getCursorPosition()), l, k, l1);
            }
            if (((EditBoxAccessor)((Object)this)).getHint() != null && s.isEmpty() && !this.isFocused()) {
                graphics.drawString(this.font, ((EditBoxAccessor)((Object)this)).getHint(), l, k, l1);
            }
            if (!flag2 && ((EditBoxAccessor)((Object)this)).getSuggestion() != null) {
                graphics.drawString(this.font, ((EditBoxAccessor)((Object)this)).getSuggestion(), j1 - 1, k, -8355712);
            }
            if (flag1) {
                if (flag2) {
                    graphics.fill(RenderPipelines.GUI, j1, k - 1, j1 + 1, k + 1 + 9, -3092272);
                } else {
                    graphics.drawString(this.font, "_", j1, k, l1);
                }
            }
            if (i1 != i) {
                int k1 = j + this.font.width(s.substring(0, i1));
                graphics.textHighlight(j1, k - 1, k1 - 1, k + 1 + 9);
            }
        }
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public void setFillColor(int fillColor, float alpha) {
        this.fillColor = RGB.toArgb(fillColor, alpha);
    }

    public boolean isDrawBackground() {
        return this.drawBackground;
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    public int getInnerWidth() {
        return this.width - 28;
    }

    public void selectAll() {
        this.moveCursorToEnd(false);
        this.setHighlightPos(0);
    }
}

