/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.ui.component.IConfigFieldHolder;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.TextBoxButton;
import journeymap.common.properties.config.CustomField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;

public class TextFieldButton
extends TextBoxButton
implements IConfigFieldHolder<CustomField> {
    protected final CustomField field;
    private int WIDTH_BUFFER = 50;

    public TextFieldButton(CustomField field) {
        super(field.get().toString());
        this.field = field;
    }

    @Override
    protected TextBox getTextBox() {
        if (this.textBox == null) {
            if (this.field.isNumber()) {
                this.textBox = new TextBox(this.field.get().toString(), this.fontRenderer, this.width, this.height, this.field.isNumber(), this.field.allowNeg());
                this.textBox.setClamp(this.field.getMinValue(), this.field.getMaxValue());
            } else {
                this.textBox = new TextBox(this.field.get().toString(), this.fontRenderer, this.width, this.height);
            }
            this.textBox.setY(this.textBox.getY() - 1);
            this.textBox.setHeight(this.textBox.getHeight() - 4);
        }
        return this.textBox;
    }

    public void setValue(Object value) {
        if (!this.field.get().equals(value)) {
            this.field.set(value);
            this.field.save();
        }
        this.getTextBox().setText(value);
    }

    public void updateValue(Object value) {
        if (!this.field.get().equals(value)) {
            this.field.set(value);
            this.field.save();
        }
    }

    @Override
    public boolean charTyped(CharacterEvent event) {
        boolean press = this.getTextBox().charTyped(event);
        this.updateValue(this.getTextBox().getValue());
        return press;
    }

    @Override
    public boolean keyPressed(KeyEvent event) {
        boolean press = this.getTextBox().keyPressed(event);
        this.updateValue(this.getTextBox().getValue());
        return press;
    }

    @Override
    public int getFitWidth(Font fr) {
        return fr.width(this.getTextBox().getValue()) + this.WIDTH_PAD + this.WIDTH_BUFFER;
    }

    @Override
    public CustomField getConfigField() {
        return this.field;
    }

    @Override
    public void refresh() {
        this.setValue(this.field.get());
    }
}

