/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.net.URLEncoder;
import journeymap.client.JourneymapClient;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.JM;
import journeymap.common.Journeymap;
import journeymap.common.version.VersionCheck;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;

public class FullscreenActions {
    public static void open() {
        UIManager.INSTANCE.openFullscreenMap();
    }

    public static void showCaveLayers() {
        UIManager.INSTANCE.openFullscreenMap().showCaveLayers();
    }

    public static void launchLocalhost() {
        String url = "http://localhost:" + String.valueOf(JourneymapClient.getInstance().getWebMapProperties().port.get());
        Util.getPlatform().openUri(url);
    }

    public static void launchWebsite(String path) {
        String url = Journeymap.WEBSITE_URL + path;
        Util.getPlatform().openUri(url);
    }

    public static void toggleSearchBar() {
        UIManager.INSTANCE.openFullscreenMap().toggleSearchBar(true);
    }

    public static void openKeybindings() {
        UIManager.INSTANCE.closeAll();
        Fullscreen fullscreen = UIManager.INSTANCE.openFullscreenMap();
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new ControlsScreen((Screen)fullscreen, mc.options));
    }

    public static void tweet(String message) {
        String url = null;
        try {
            url = "http://twitter.com/home/?status=@JourneyMapMod+" + URLEncoder.encode(message, "UTF-8");
            Util.getPlatform().openUri(url);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void discord() {
        String url = JM.DISCORD_URL;
        Util.getPlatform().openUri(url);
    }

    public static void changeLog() {
        String url = "https://gist.github.com/mysticdrew/d0a59ca9509bcb2a3566437621d9ee4e";
        Util.getPlatform().openUri(url);
    }

    public static void webmapDownloadCF() {
        String url = "https://www.curseforge.com/minecraft/mc-mods/journeymap-web-map";
        Util.getPlatform().openUri(url);
    }

    public static void webmapDownloadMR() {
        String url = "https://modrinth.com/mod/journeymap-web-map";
        Util.getPlatform().openUri(url);
    }

    public static void launchDownloadWebsite() {
        String url = VersionCheck.getDownloadUrl();
        Util.getPlatform().openUri(url);
    }

    public static void launchWebMapDownloadWebsite(String url) {
        Util.getPlatform().openUri(url);
    }
}

