/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.waypoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class DimensionSlot
extends ManagerSlot {
    private final String dimName;
    private final String dimId;
    private Component enabledText;
    private Component disabledText;
    private StringWidget nameWidget;
    private CheckBox checkBox;
    private boolean enabled;
    private boolean primary;
    private ManagerSlot.ToolTipMeta tooltip;
    private LinearLayout layout = LinearLayout.horizontal();

    public DimensionSlot(String dimId, String dimName, boolean enabled, boolean primary) {
        this.dimId = dimId;
        this.dimName = dimName;
        this.enabled = enabled;
        this.primary = primary;
        this.enabledText = Component.literal((String)dimName);
        this.disabledText = Component.literal((String)dimName).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.STRIKETHROUGH);
        this.tooltip = new ManagerSlot.ToolTipMeta(new ArrayList<FormattedCharSequence>(Collections.singleton(FormattedCharSequence.forward((String)this.dimId, (Style)Style.EMPTY))));
    }

    @Override
    public void repositionElements() {
        this.layout.arrangeElements();
        FrameLayout.centerInRectangle((LayoutElement)this.layout, (ScreenRectangle)this.getRectangle());
    }

    @Override
    public void init() {
        Font font = Minecraft.getInstance().font;
        this.nameWidget = (StringWidget)this.layout.addChild((LayoutElement)new StringWidget(this.enabled ? this.enabledText : this.disabledText, 85, font).alignLeft(), LayoutSettings::alignVerticallyMiddle);
        this.checkBox = (CheckBox)this.layout.addChild((LayoutElement)new CheckBox("", this.primary, this::onPrimaryCheck), LayoutSettings::alignHorizontallyRight);
        this.checkBox.setDrawText(false);
        this.repositionElements();
    }

    private void onPrimaryCheck(Button button) {
        this.primary = ((CheckBox)button).getToggled();
    }

    @Override
    public Layout getLayout() {
        return this.layout;
    }

    @Override
    public void setEnabled(boolean selected) {
        this.enabled = selected;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
        this.checkBox.setToggled(primary);
    }

    public void renderContent(GuiGraphics graphics, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        int x = this.getContentX();
        int y = this.getContentY();
        int rowWidth = this.getContentWidth();
        int itemHeight = this.getContentHeight();
        this.layout.setX(x + 3);
        this.layout.setY(y + 2);
        Integer color = isMouseOver ? backgroundHover : background;
        float alpha = isMouseOver ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth - 8, itemHeight, color, alpha);
        this.layout.visitWidgets(widget -> widget.render(graphics, mouseX, mouseY, partialTicks));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean clicked = super.mouseClicked(event, doubleClick);
        if (!this.checkBox.isMouseOver(event.x(), event.y())) {
            this.enabled = !this.enabled;
            this.nameWidget.setMessage(this.enabled ? this.enabledText : this.disabledText);
        }
        return clicked;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDimId() {
        return this.dimId;
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.visitWidgets(widget -> {
            Button button;
            if (widget instanceof Button && (button = (Button)widget).isHovered()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltip : null;
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }
}

