/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import journeymap.api.services.Services;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class WorldIdData
extends SavedData {
    private final String worldId;
    private static final Codec<WorldIdData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("world_uuid").forGetter(WorldIdData::getNBTWorldID)).apply((Applicative)instance, WorldIdData::new));
    private static final SavedDataType<WorldIdData> TYPE = new SavedDataType("WorldUUID", WorldIdData::new, CODEC, DataFixTypes.OPTIONS);

    public WorldIdData(String worldId) {
        this.worldId = worldId;
    }

    public WorldIdData() {
        this(UUID.randomUUID().toString());
        this.setDirty();
    }

    public static String getWorldId() {
        return WorldIdData.get().getNBTWorldID();
    }

    static WorldIdData get() {
        ServerLevel level = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        return (WorldIdData)level.getDataStorage().computeIfAbsent(TYPE);
    }

    private String getNBTWorldID() {
        return this.worldId;
    }
}

