/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography.color;

import com.mojang.blaze3d.platform.NativeImage;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class ColoredSprite {
    private static Logger logger = Journeymap.getLogger();
    private final Integer color;
    private final TextureAtlasSprite sprite;

    public ColoredSprite(TextureAtlasSprite sprite, @Nullable Integer color) {
        this.sprite = sprite;
        this.color = null;
    }

    public ColoredSprite(BakedQuad quad) {
        this.sprite = quad.sprite();
        this.color = null;
    }

    public String getIconName() {
        return this.sprite.contents().name().getPath();
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != null;
    }

    @Nullable
    public NativeImage getColoredImage() {
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)this.getIconName());
            if (resourceLocation.equals((Object)ResourceLocation.parse((String)"missingno"))) {
                return null;
            }
            NativeImage image = this.sprite.contents().byMipLevel[0];
            if (image == null || image.getWidth() == 0) {
                image = this.getImageResource(this.sprite);
            }
            if (image == null || image.getWidth() == 0) {
                return null;
            }
            return image;
        }
        catch (Throwable e1) {
            if (logger.isDebugEnabled()) {
                logger.error("ColoredSprite: Error getting image for " + this.getIconName() + ": " + LogFormatter.toString(e1));
            }
            return null;
        }
    }

    private NativeImage getImageResource(TextureAtlasSprite tas) {
        try {
            ResourceLocation iconNameLoc = ResourceLocation.parse((String)tas.contents().name().getPath());
            ResourceLocation fileLoc = ResourceLocation.fromNamespaceAndPath((String)iconNameLoc.getNamespace(), (String)("textures/" + iconNameLoc.getPath() + ".png"));
            return TextureCache.resolveImage(fileLoc);
        }
        catch (Throwable t) {
            logger.error(String.format("ColoredSprite: Unable to use texture file for %s: %s", tas.contents().name().getPath(), t.getMessage()));
            return null;
        }
    }
}

