/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.component.cca.entity;

import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3738;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import survivalblock.rods_from_god.common.RodsFromGod;
import survivalblock.rods_from_god.common.init.RodsFromGodEntityComponents;
import survivalblock.rods_from_god.mixin.corruptedstarfragment.DamageSourceAccessor;
import survivalblock.rods_from_god.mixin.corruptedstarfragment.EntityAccessor;

public class DeathExplosionComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private boolean shouldExplodeOnDeath = false;
    private class_1282 finalDeathSource = null;
    private final int fuseTime = 50;
    private int lastFuseTime;
    private int currentFuseTime;
    private class_243 deathPos = class_243.field_1353;

    public DeathExplosionComponent(class_1657 player) {
        this.obj = player;
    }

    public void tick() {
        if (!this.shouldExplodeOnDeath) {
            return;
        }
        this.obj.method_18799(class_243.field_1353);
        this.obj.method_33574(this.deathPos);
        this.obj.method_43391(this.deathPos.field_1352, this.deathPos.field_1351, this.deathPos.field_1350);
        this.lastFuseTime = this.currentFuseTime++;
        if (this.currentFuseTime < 0) {
            this.currentFuseTime = 0;
        }
        if (this.currentFuseTime >= this.fuseTime) {
            this.currentFuseTime = this.fuseTime;
            this.explode();
        }
    }

    protected void updateDeathPos() {
        this.deathPos = new class_243(this.obj.method_19538().method_10216(), this.obj.method_19538().method_10214(), this.obj.method_19538().method_10215());
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        class_1937 class_19372;
        this.shouldExplodeOnDeath = nbtCompound.method_10577("shouldExplodeOnDeath");
        if (nbtCompound.method_10545("lastFuseTime")) {
            this.lastFuseTime = nbtCompound.method_10550("lastFuseTime");
        }
        if (nbtCompound.method_10545("currentFuseTime")) {
            this.currentFuseTime = nbtCompound.method_10550("currentFuseTime");
        }
        if (nbtCompound.method_10545("damageSourceTypeID") && (class_19372 = this.obj.method_37908()) instanceof class_3218) {
            class_1297 entity;
            class_3218 serverWorld = (class_3218)class_19372;
            class_8110 damageType = (class_8110)serverWorld.method_48963().field_42296.method_10223(class_2960.method_60654((String)nbtCompound.method_10558("damageSourceTypeID")));
            class_6880 damageTypeRegistryEntry = serverWorld.method_48963().field_42296.method_47983((Object)damageType);
            class_1297 attacker = null;
            class_1297 source = null;
            class_243 storedPosition = null;
            if (nbtCompound.method_10545("damageSourceAttacker") && (entity = serverWorld.method_14190(nbtCompound.method_25926("damageSourceAttacker"))) != null) {
                attacker = entity;
            }
            if (nbtCompound.method_10545("damageSourceSource") && (entity = serverWorld.method_14190(nbtCompound.method_25926("damageSourceSource"))) != null) {
                source = entity;
            }
            if (nbtCompound.method_10545("damageSourceStoredPosition")) {
                try {
                    if (nbtCompound.method_10545("damageSourceStoredPosition")) {
                        class_2499 nbtList = nbtCompound.method_10554("damageSourceStoredPosition", 6);
                        storedPosition = new class_243(class_3532.method_15350((double)nbtList.method_10611(0), (double)-3.0000512E7, (double)3.0000512E7), class_3532.method_15350((double)nbtList.method_10611(1), (double)-2.0E7, (double)2.0E7), class_3532.method_15350((double)nbtList.method_10611(2), (double)-3.0000512E7, (double)3.0000512E7));
                    }
                }
                catch (Throwable throwable) {
                    class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Loading entity NBT");
                    class_129 crashReportSection = crashReport.method_562("Entity being loaded");
                    this.obj.method_5819(crashReportSection);
                    RodsFromGod.LOGGER.error("Error while loading Death Explosion Component Damage Source Position", (Throwable)new class_148(crashReport));
                }
            }
            this.finalDeathSource = DamageSourceAccessor.rods_from_god$invokeConstructor((class_6880<class_8110>)damageTypeRegistryEntry, source, attacker, storedPosition);
        }
        try {
            if (nbtCompound.method_10545("deathPos")) {
                class_2499 nbtList = nbtCompound.method_10554("deathPos", 6);
                this.deathPos = new class_243(class_3532.method_15350((double)nbtList.method_10611(0), (double)-3.0000512E7, (double)3.0000512E7), class_3532.method_15350((double)nbtList.method_10611(1), (double)-2.0E7, (double)2.0E7), class_3532.method_15350((double)nbtList.method_10611(2), (double)-3.0000512E7, (double)3.0000512E7));
            }
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Loading entity NBT");
            class_129 crashReportSection = crashReport.method_562("Entity being loaded");
            this.obj.method_5819(crashReportSection);
            RodsFromGod.LOGGER.error("Error while loading Death Explosion Component Position", (Throwable)new class_148(crashReport));
            this.updateDeathPos();
        }
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        class_2960 id;
        nbtCompound.method_10556("shouldExplodeOnDeath", this.shouldExplodeOnDeath);
        nbtCompound.method_10569("lastFuseTime", this.lastFuseTime);
        nbtCompound.method_10569("currentFuseTime", this.currentFuseTime);
        if (this.finalDeathSource != null && (id = this.obj.method_37908().method_48963().field_42296.method_10221((Object)this.finalDeathSource.method_48792())) != null) {
            class_243 vec3d;
            class_1297 source;
            nbtCompound.method_10582("damageSourceTypeID", id.toString());
            class_1297 attacker = this.finalDeathSource.method_5529();
            if (attacker != null) {
                nbtCompound.method_25927("damageSourceAttacker", attacker.method_5667());
            }
            if ((source = this.finalDeathSource.method_5526()) != null) {
                nbtCompound.method_25927("damageSourceSource", source.method_5667());
            }
            if ((vec3d = this.finalDeathSource.method_48791()) != null) {
                nbtCompound.method_10566("damageSourceStoredPosition", (class_2520)((EntityAccessor)this.obj).rods_from_god$invokeToNbtList(vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215()));
            }
        }
        nbtCompound.method_10566("deathPos", (class_2520)((EntityAccessor)this.obj).rods_from_god$invokeToNbtList(this.deathPos.method_10216(), this.deathPos.method_10214(), this.deathPos.method_10215()));
    }

    public boolean shouldExplodeOnDeath() {
        return this.shouldExplodeOnDeath;
    }

    public void setShouldExplodeOnDeath(boolean shouldExplodeOnDeath) {
        this.shouldExplodeOnDeath = shouldExplodeOnDeath;
        RodsFromGodEntityComponents.DEATH_EXPLOSION.sync((Object)this.obj);
    }

    public void setup(boolean shouldExplodeOnDeath, class_1282 finalDeathSource) {
        this.finalDeathSource = finalDeathSource;
        this.updateDeathPos();
        this.setShouldExplodeOnDeath(shouldExplodeOnDeath);
    }

    public void explode() {
        class_1937 class_19372 = this.obj.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        this.setShouldExplodeOnDeath(false);
        serverWorld.method_8437((class_1297)this.obj, this.obj.method_23317(), this.obj.method_23318(), this.obj.method_23321(), 8.0f, class_1937.class_7867.field_40890);
        this.obj.method_6033(1.0f);
        MinecraftServer server = serverWorld.method_8503();
        server.method_18858((Runnable)new class_3738(server.method_3780(), () -> {
            this.obj.method_6033(1.0f);
            class_1282 source = this.finalDeathSource == null ? serverWorld.method_48963().method_48819((class_1297)this.obj, (class_1297)this.obj) : this.finalDeathSource;
            boolean result = this.obj.method_5643(source, Float.MAX_VALUE);
            if (!result) {
                this.obj.method_5768();
            }
        }));
    }

    public float getClientFuseTime(float timeDelta) {
        return class_3532.method_16439((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2);
    }
}

