/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.component.cca.world;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import survivalblock.atmosphere.atmospheric_api.not_mixin.render.screenshake.ScreenShakeS2CPayload;
import survivalblock.rods_from_god.common.init.RodsFromGodTags;
import survivalblock.rods_from_god.common.init.RodsFromGodWorldComponents;

public class WorldLeverComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1937 world;
    private boolean lifted = false;
    private boolean switching = false;
    private int celestialZoom;
    public static final int MAX_CELESTIAL_ZOOM = 60;
    public static final float MAX_CELESTIAL_SCALE = 8.0f;

    public WorldLeverComponent(class_1937 world) {
        this.world = world;
    }

    public boolean lifted() {
        return this.lifted;
    }

    public boolean setLifted(boolean lifted) {
        class_1937 class_19372 = this.world;
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        if (this.lifted == lifted) {
            return false;
        }
        if (!this.canSwitch(serverWorld)) {
            return false;
        }
        for (class_3222 serverPlayer : serverWorld.method_18456()) {
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new ScreenShakeS2CPayload(0.2f, 60, "rods_from_god", "archimedes_lever_world_lifting"));
        }
        this.lifted = lifted;
        this.switching = true;
        this.celestialZoom = 60;
        RodsFromGodWorldComponents.WORLD_LEVER.sync((Object)this.world);
        return true;
    }

    public boolean canSwitch(class_3218 serverWorld) {
        return serverWorld.method_40134().method_40220(RodsFromGodTags.SUN_AND_MOON);
    }

    public boolean isLifted() {
        return this.lifted;
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.lifted = nbtCompound.method_10577("lifted");
        this.switching = nbtCompound.method_10577("switching");
        this.celestialZoom = nbtCompound.method_10550("celestialZoom");
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10556("lifted", this.lifted);
        nbtCompound.method_10556("switching", this.switching);
        nbtCompound.method_10569("celestialZoom", this.celestialZoom);
    }

    public void tick() {
        if (this.switching) {
            if (this.celestialZoom > 0) {
                --this.celestialZoom;
            } else {
                this.celestialZoom = 0;
                this.switching = false;
            }
        }
        if (this.celestialZoom <= 0) {
            this.celestialZoom = 0;
            this.switching = false;
        }
    }

    public boolean isSwitching() {
        return this.switching;
    }

    public int getCelestialZoom() {
        return this.celestialZoom;
    }
}

