/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common;

import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import survivalblock.atmosphere.atmospheric_api.not_mixin.AtmosphericAPI;
import survivalblock.atmosphere.atmospheric_api.not_mixin.render.screenshake.ScreenShakePreventerRegistry;
import survivalblock.atmosphere.atmospheric_api.not_mixin.render.screenshake.ScreenShaker;
import survivalblock.atmosphere.atmospheric_api.not_mixin.resource.AtmosphericResourceManagerHelper;
import survivalblock.rods_from_god.client.networking.BookTargetC2SPayload;
import survivalblock.rods_from_god.client.networking.TheOneWatchComponentC2SPayload;
import survivalblock.rods_from_god.common.block.SynthesisTable;
import survivalblock.rods_from_god.common.compat.config.RodsFromGodConfig;
import survivalblock.rods_from_god.common.init.RodsFromGodBlocks;
import survivalblock.rods_from_god.common.init.RodsFromGodCommands;
import survivalblock.rods_from_god.common.init.RodsFromGodDataComponentTypes;
import survivalblock.rods_from_god.common.init.RodsFromGodEntityTypes;
import survivalblock.rods_from_god.common.init.RodsFromGodGameRules;
import survivalblock.rods_from_god.common.init.RodsFromGodItems;
import survivalblock.rods_from_god.common.init.RodsFromGodSoundEvents;
import survivalblock.rods_from_god.common.init.RodsFromGodStatusEffects;
import survivalblock.rods_from_god.common.init.RodsFromGodWorldComponents;
import survivalblock.rods_from_god.common.recipe.AimingDeviceRecipe;

public class RodsFromGod
implements ModInitializer {
    public static final String MOD_ID = "rods_from_god";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Rods from God");
    public static final UUID SkyNotTheLimit = UUID.fromString("c45e97e6-94ef-42da-8b5e-0c3209551c3f");
    public static final class_2960 ARCHIMEDES_LEVER_ALLOW_OVERWORLD = RodsFromGod.id("archimedes_lever_allow_lifting_overworld");
    public static final String ARCHIMEDES_LEVER_SCREENSHAKE_REASON = "archimedes_lever_world_lifting";
    public static boolean shouldDoConfig = false;
    public static boolean configLoaded = false;

    public void onInitialize() {
        AtmosphericAPI.resetIsConnectorLoaded();
        shouldDoConfig = FabricLoader.getInstance().isModLoaded("yet_another_config_lib_v3");
        if (shouldDoConfig && !(configLoaded = RodsFromGodConfig.load())) {
            LOGGER.warn("Rods from God Config could not be loaded!");
        }
        ScreenShakePreventerRegistry.ALLOW_SHAKING.register(screenShaker -> {
            if (RodsFromGod.isWorldLeverShake(screenShaker)) {
                return RodsFromGodConfig.allowScreenShakingForArchimedesLever();
            }
            return true;
        });
        RodsFromGodEntityTypes.init();
        RodsFromGodSoundEvents.init();
        RodsFromGodGameRules.init();
        RodsFromGodDataComponentTypes.init();
        RodsFromGodBlocks.init();
        RodsFromGodItems.init();
        RodsFromGodStatusEffects.init();
        RodsFromGodStatusEffects.RodsFromGodPotions.init();
        CommandRegistrationCallback.EVENT.register(RodsFromGodCommands::init);
        SynthesisTable.SynthesisScreenHandler.init();
        AimingDeviceRecipe.init();
        PayloadTypeRegistry.playC2S().register(TheOneWatchComponentC2SPayload.ID, TheOneWatchComponentC2SPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(BookTargetC2SPayload.ID, BookTargetC2SPayload.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(TheOneWatchComponentC2SPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)TheOneWatchComponentC2SPayload.Receiver.INSTANCE);
        ServerPlayNetworking.registerGlobalReceiver(BookTargetC2SPayload.ID, (ServerPlayNetworking.PlayPayloadHandler)BookTargetC2SPayload.Receiver.INSTANCE);
        FabricLoader.getInstance().getModContainer(MOD_ID).ifPresent(RodsFromGod::registerBuiltinDataPacks);
        ServerPlayConnectionEvents.JOIN.register((serverPlayNetworkHandler, packetSender, server) -> server.method_3738().forEach(arg_0 -> RodsFromGodWorldComponents.WORLD_LEVER.sync(arg_0)));
    }

    public static boolean isWorldLeverShake(ScreenShaker screenShaker) {
        return Objects.equals(MOD_ID, screenShaker.getModId()) && Objects.equals(ARCHIMEDES_LEVER_SCREENSHAKE_REASON, screenShaker.getReason());
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void registerBuiltinDataPacks(ModContainer modContainer) {
        AtmosphericResourceManagerHelper.registerBuiltinDataPack((class_2960)ARCHIMEDES_LEVER_ALLOW_OVERWORLD, (ModContainer)modContainer, (class_2561)class_2561.method_43471((String)"dataPack.rods_from_god.archimedes_lever_allow_lifting_overworld.name"), (ResourcePackActivationType)ResourcePackActivationType.DEFAULT_ENABLED);
    }
}

