/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.component.cca.entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;
import survivalblock.rods_from_god.common.RodsFromGod;
import survivalblock.rods_from_god.common.init.RodsFromGodEntityComponents;

public class StoneStatueComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    public static final class_2960 STONE_BLOCK = class_2960.method_60656((String)"textures/block/stone.png");
    public static final class_2960 STONE_BRICKS = class_2960.method_60656((String)"textures/block/stone_bricks.png");
    public static final int MAX_STATUE_TICKS = 200;
    private final class_1309 obj;
    private int ticksInStone = 0;
    private class_243 position;
    private class_4050 pose;
    private boolean showcase = false;
    public float limbAngle;
    public float limbDistance;
    public float headYaw;
    public float bodyYaw;
    public float pitch;
    private boolean shouldSendAll = true;
    private boolean alreadySynced = false;

    public StoneStatueComponent(class_1309 living) {
        this.obj = living;
        this.position = living.method_19538();
        this.pose = living.method_18376();
    }

    public void tick() {
        if (this.obj.method_31481() || this.obj.method_29504()) {
            if (this.ticksInStone != 0 || this.showcase) {
                this.ticksInStone = 0;
                this.showcase = false;
                this.sync();
            }
            return;
        }
        if (this.ticksInStone > 0 || this.showcase) {
            if (this.ticksInStone > 200) {
                this.ticksInStone = 200;
            }
            class_4095 brain = this.obj.method_18868();
            brain.method_18875(class_4140.field_22355);
            brain.method_18875(class_4140.field_22333);
            if (this.obj.method_18798().method_1027() > 1.0E-7 && this.obj.method_5787()) {
                this.obj.method_18799(class_243.field_1353);
                if (this.obj instanceof class_3222) {
                    this.obj.field_6037 = true;
                }
            }
            if (this.obj.method_5707(this.position) > 0.01) {
                this.obj.method_33574(this.position);
                this.obj.method_43391(this.position.field_1352, this.position.field_1351, this.position.field_1350);
            }
            this.obj.method_18380(this.pose);
            this.obj.method_5847(this.headYaw);
            this.obj.field_6259 = this.headYaw;
            this.obj.method_5636(this.bodyYaw);
            this.obj.field_6220 = this.bodyYaw;
            this.obj.method_36456(this.bodyYaw);
            this.obj.field_5982 = this.bodyYaw;
            this.obj.method_36457(this.pitch);
            this.obj.field_6004 = this.pitch;
            class_1309 class_13092 = this.obj;
            if (class_13092 instanceof class_1314) {
                class_1314 pathAwareEntity = (class_1314)class_13092;
                pathAwareEntity.method_5942().method_6340();
            }
            if (this.obj.method_5854() != null) {
                this.obj.method_5848();
            }
        } else if (this.ticksInStone < 0) {
            this.ticksInStone = 0;
        }
        this.shouldSendAll = true;
        if (this.obj.method_37908().method_8510() % 100L == 0L) {
            this.sync();
        }
        this.alreadySynced = false;
    }

    public void readFromNbt(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        this.ticksInStone = nbt.method_10550("ticksInStone");
        if (nbt.method_10545("showcase")) {
            this.showcase = nbt.method_10577("showcase");
        }
        if (nbt.method_10545("pose")) {
            this.pose = class_4050.valueOf((String)nbt.method_10558("pose"));
        }
        if (nbt.method_10545("position")) {
            this.position = class_243.field_38277.parse((DynamicOps)wrapperLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("position")).resultOrPartial(error -> RodsFromGod.LOGGER.error("Tried to load invalid Vec3d: '{}'", error)).orElse(this.obj.method_19538());
        }
        if (nbt.method_10545("headYaw")) {
            this.headYaw = nbt.method_10583("headYaw");
        }
        if (nbt.method_10545("bodyYaw")) {
            this.bodyYaw = nbt.method_10583("bodyYaw");
        }
        if (nbt.method_10545("pitch")) {
            this.pitch = nbt.method_10583("pitch");
        }
        if (nbt.method_10545("limbAngle")) {
            this.limbAngle = nbt.method_10583("limbAngle");
        }
        if (nbt.method_10545("limbDistance")) {
            this.limbDistance = nbt.method_10583("limbDistance");
        }
    }

    public void writeToNbt(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        this.writeBasicDataToNbt(nbt, wrapperLookup);
        nbt.method_10582("pose", this.pose.toString());
        nbt.method_10566("position", (class_2520)class_243.field_38277.encodeStart((DynamicOps)wrapperLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this.position).getOrThrow());
        nbt.method_10548("headYaw", this.headYaw);
        nbt.method_10548("bodyYaw", this.bodyYaw);
        nbt.method_10548("pitch", this.pitch);
        nbt.method_10548("limbAngle", this.limbAngle);
        nbt.method_10548("limbDistance", this.limbDistance);
    }

    private void writeBasicDataToNbt(class_2487 nbt, class_7225.class_7874 wrapperLookup) {
        nbt.method_10569("ticksInStone", this.ticksInStone);
        nbt.method_10556("showcase", this.showcase);
    }

    public boolean isStatue() {
        return this.ticksInStone > 0 || this.showcase;
    }

    public float getOverlayFactor() {
        return (float)Math.min(this.ticksInStone, 200) / 200.0f;
    }

    public void setInStone(boolean showcase, boolean autoSync) {
        this.setInStone(200, showcase, autoSync);
    }

    public void setInStone(int ticksInStone, boolean showcase, boolean autoSync) {
        boolean alreadyStatue = this.isStatue();
        this.ticksInStone = ticksInStone;
        this.showcase = showcase;
        if (alreadyStatue) {
            if (autoSync) {
                this.shouldSendAll = false;
                this.sync();
            }
            return;
        }
        if (ticksInStone > 0) {
            this.shouldSendAll = true;
            this.position = this.obj.method_19538();
            this.pose = this.obj.method_18376();
            this.headYaw = this.obj.method_5791();
            this.bodyYaw = this.obj.method_36454();
            this.pitch = this.obj.method_36455();
            this.limbAngle = this.obj.field_42108.method_48569();
            this.limbDistance = this.obj.field_42108.method_48566();
        }
        if (autoSync) {
            this.sync();
        }
    }

    public boolean showcase() {
        return this.showcase;
    }

    public void writeSyncPacket(class_9129 buf, class_3222 recipient) {
        class_2487 nbt = new class_2487();
        if (this.shouldSendAll) {
            this.writeToNbt(nbt, (class_7225.class_7874)buf.method_56349());
        } else {
            this.writeBasicDataToNbt(nbt, (class_7225.class_7874)buf.method_56349());
        }
        buf.method_10794((class_2520)nbt);
    }

    public void sync() {
        if (this.alreadySynced) {
            return;
        }
        RodsFromGodEntityComponents.STONE_STATUE.sync((Object)this.obj);
        this.alreadySynced = true;
    }

    public static class_2960 getStoneTexture(class_2960 original, class_1309 living) {
        StoneStatueComponent stoneStatueComponent = (StoneStatueComponent)RodsFromGodEntityComponents.STONE_STATUE.get((Object)living);
        if (!stoneStatueComponent.isStatue()) {
            return original;
        }
        if (stoneStatueComponent.showcase || (double)stoneStatueComponent.ticksInStone / 200.0 > 0.5) {
            return STONE_BLOCK;
        }
        return STONE_BRICKS;
    }

    public static boolean isEntityLookingAtMe(class_1309 other, class_1309 me, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        class_243 rotationVec = other.method_5828(1.0f).method_1029();
        for (double y : yValues) {
            class_243 vec3d = new class_243(me.method_23317() - other.method_23317(), y - other.method_23320(), me.method_23321() - other.method_23321());
            double length = vec3d.method_1033();
            vec3d = vec3d.method_1029();
            double dotProduct = rotationVec.method_1026(vec3d);
            double d = scaleByDistance ? length : 1.0;
            if (!(dotProduct > 1.0 - tolerance / d) || !StoneStatueComponent.canSee(other, me, visual ? class_3959.class_3960.field_23142 : class_3959.class_3960.field_17558, class_3959.class_242.field_1348, y)) continue;
            return true;
        }
        return false;
    }

    public static boolean canSee(class_1309 other, class_1309 me, class_3959.class_3960 shapeType, class_3959.class_242 fluidHandling, double y) {
        if (other.method_37908() != me.method_37908()) {
            return false;
        }
        class_243 vec3d = new class_243(me.method_23317(), me.method_23320(), me.method_23321());
        class_243 vec3d2 = new class_243(other.method_23317(), y, other.method_23321());
        return !(vec3d2.method_1022(vec3d) > 128.0) && me.method_37908().method_17742(new class_3959(vec3d, vec3d2, shapeType, fluidHandling, (class_1297)me)).method_17783() == class_239.class_240.field_1333;
    }
}

