/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.component.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import survivalblock.atmosphere.atmospheric_api.not_mixin.datafixer.AtmosphericPacketCodecs;

public class AimingDeviceComponent
implements class_9299 {
    public static final AimingDeviceComponent DEFAULT_INSTANCE = new Builder().build();
    public static final AimingDeviceComponent CREATES_FIRE = new Builder().createsFire(true).build();
    public static final AimingDeviceComponent SMALL_BUT_SPEEDY = new Builder().cooldown(10).scale(1.0f).gravity(10.0).build();
    public static final AimingDeviceComponent DESTROYER = new Builder().cooldown(300).scale(128.0f).inverseExplosionDamageFactor(25).build();
    public static final Codec<AimingDeviceComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.optionalFieldOf("cooldown").forGetter(component -> component.cooldown), (App)class_5699.field_33441.optionalFieldOf("maxExplosions").forGetter(component -> component.maxExplosions), (App)class_5699.field_33441.optionalFieldOf("explosionPower").forGetter(component -> component.explosionPower), (App)class_5699.field_33441.optionalFieldOf("inverseExplosionDamageFactor").forGetter(component -> component.inverseExplosionDamageFactor), (App)Codec.DOUBLE.optionalFieldOf("gravity").forGetter(component -> component.gravity), (App)class_5699.field_34387.optionalFieldOf("scale").forGetter(component -> component.scale), (App)Codec.BOOL.optionalFieldOf("createsFire").forGetter(component -> component.createsFire)).apply((Applicative)instance, AimingDeviceComponent::new));
    public static final class_9139<class_9129, AimingDeviceComponent> PACKET_CODEC = AtmosphericPacketCodecs.tuple((class_9139)class_9135.field_48550.method_56433(class_9135::method_56382), component -> component.cooldown, (class_9139)class_9135.field_48550.method_56433(class_9135::method_56382), component -> component.maxExplosions, (class_9139)class_9135.field_48550.method_56433(class_9135::method_56382), component -> component.explosionPower, (class_9139)class_9135.field_48550.method_56433(class_9135::method_56382), component -> component.inverseExplosionDamageFactor, (class_9139)class_9135.field_48553.method_56433(class_9135::method_56382), component -> component.gravity, (class_9139)class_9135.field_48552.method_56433(class_9135::method_56382), component -> component.scale, (class_9139)class_9135.field_48547.method_56433(class_9135::method_56382), component -> component.createsFire, AimingDeviceComponent::new);
    private final Optional<Integer> cooldown;
    private final Optional<Integer> maxExplosions;
    private final Optional<Integer> explosionPower;
    private final Optional<Integer> inverseExplosionDamageFactor;
    private final Optional<Double> gravity;
    private final Optional<Float> scale;
    private final Optional<Boolean> createsFire;

    public AimingDeviceComponent(int cooldown, int maxExplosions, int explosionPower, int inverseExplosionDamageFactor, double gravity, float scale, boolean createsFire) {
        this(Optional.of(cooldown), Optional.of(maxExplosions), Optional.of(explosionPower), Optional.of(inverseExplosionDamageFactor), Optional.of(gravity), Optional.of(Float.valueOf(scale)), Optional.of(createsFire));
    }

    public AimingDeviceComponent(Optional<Integer> cooldown, Optional<Integer> maxExplosions, Optional<Integer> explosionPower, Optional<Integer> inverseExplosionDamageFactor, Optional<Double> gravity, Optional<Float> scale, Optional<Boolean> createsFire) {
        this.cooldown = cooldown;
        this.maxExplosions = maxExplosions;
        this.explosionPower = explosionPower;
        this.inverseExplosionDamageFactor = inverseExplosionDamageFactor;
        this.gravity = gravity;
        this.scale = scale;
        this.createsFire = createsFire;
    }

    public int cooldown() {
        return this.cooldown.orElse(200);
    }

    public int maxExplosions() {
        return this.maxExplosions.orElse(5);
    }

    public int explosionPower() {
        return this.explosionPower.orElse(10);
    }

    public int inverseExplosionDamageFactor() {
        return this.inverseExplosionDamageFactor.orElse(100);
    }

    public double gravity() {
        return this.gravity.orElse(0.1);
    }

    public float scale() {
        return this.scale.orElse(Float.valueOf(16.0f)).floatValue();
    }

    public boolean createsFire() {
        return this.createsFire.orElse(false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AimingDeviceComponent) {
            AimingDeviceComponent aimingDeviceComponent = (AimingDeviceComponent)obj;
            return this.cooldown() == aimingDeviceComponent.cooldown() && this.maxExplosions() == aimingDeviceComponent.maxExplosions() && this.explosionPower() == aimingDeviceComponent.explosionPower() && this.inverseExplosionDamageFactor() == aimingDeviceComponent.inverseExplosionDamageFactor() && this.gravity() == aimingDeviceComponent.gravity() && this.scale() == aimingDeviceComponent.scale() && this.createsFire() == aimingDeviceComponent.createsFire();
        }
        return false;
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.createsFire()) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"item.rods_from_god.aiming_device.aiming_device_creates_fire").method_54663(16742418));
        }
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_cooldown", (Object[])new Object[]{this.cooldown()}).method_27692(class_124.field_1080));
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_max_explosions", (Object[])new Object[]{this.maxExplosions()}).method_27692(class_124.field_1080));
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_explosion_power", (Object[])new Object[]{this.explosionPower()}).method_27692(class_124.field_1080));
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_inverse_explosion_damage_factor", (Object[])new Object[]{this.inverseExplosionDamageFactor()}).method_27692(class_124.field_1080));
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_gravity", (Object[])new Object[]{this.gravity()}).method_27692(class_124.field_1080));
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.rods_from_god.aiming_device.aiming_device_scale", (Object[])new Object[]{Float.valueOf(this.scale())}).method_27692(class_124.field_1080));
    }

    public static class Builder {
        private int cooldown = 200;
        private int maxExplosions = 5;
        private int explosionPower = 10;
        private int inverseExplosionDamageFactor = 100;
        private double gravity = 0.1;
        private float scale = 16.0f;
        private boolean createsFire = false;

        public AimingDeviceComponent build() {
            return new AimingDeviceComponent(this.cooldown, this.maxExplosions, this.explosionPower, this.inverseExplosionDamageFactor, this.gravity, this.scale, this.createsFire);
        }

        public Builder copyFrom(Builder other) {
            this.cooldown = other.cooldown;
            this.maxExplosions = other.maxExplosions;
            this.explosionPower = other.explosionPower;
            this.inverseExplosionDamageFactor = other.inverseExplosionDamageFactor;
            this.gravity = other.gravity;
            this.scale = other.scale;
            this.createsFire = other.createsFire;
            return this;
        }

        public Builder copyFrom(AimingDeviceComponent aimingDeviceComponent) {
            this.cooldown = aimingDeviceComponent.cooldown();
            this.maxExplosions = aimingDeviceComponent.maxExplosions();
            this.explosionPower = aimingDeviceComponent.explosionPower();
            this.inverseExplosionDamageFactor = aimingDeviceComponent.inverseExplosionDamageFactor();
            this.gravity = aimingDeviceComponent.gravity();
            this.scale = aimingDeviceComponent.scale();
            this.createsFire = aimingDeviceComponent.createsFire();
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder maxExplosions(int maxExplosions) {
            this.maxExplosions = maxExplosions;
            return this;
        }

        public Builder explosionPower(int explosionPower) {
            this.explosionPower = explosionPower;
            return this;
        }

        public Builder inverseExplosionDamageFactor(int inverseExplosionDamageFactor) {
            this.inverseExplosionDamageFactor = inverseExplosionDamageFactor;
            return this;
        }

        public Builder gravity(double gravity) {
            this.gravity = gravity;
            return this;
        }

        public Builder scale(float scale) {
            this.scale = scale;
            return this;
        }

        public Builder createsFire(boolean createsFire) {
            this.createsFire = createsFire;
            return this;
        }
    }
}

