/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.entity;

import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_148;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import survivalblock.atmosphere.atmospheric_api.not_mixin.entity.EntityWithAttributesImpl;
import survivalblock.rods_from_god.common.RodsFromGod;
import survivalblock.rods_from_god.common.entity.RodLandingMarkerEntity;
import survivalblock.rods_from_god.common.init.RodsFromGodDamageTypes;
import survivalblock.rods_from_god.common.init.RodsFromGodEntityTypes;
import survivalblock.rods_from_god.common.init.RodsFromGodGameRules;
import survivalblock.rods_from_god.common.init.RodsFromGodSoundEvents;

public class TungstenRodEntity
extends EntityWithAttributesImpl {
    public static final String EXPLOSION_COUNTER_NBT_KEY = "explosionCounter";
    public static final String EXPLOSION_BOOLEAN_NBT_KEY = "shouldExplode";
    public static final String EXPLOSION_POS_NBT_KEY = "explosionPos";
    public static final String MAXIMUM_EXPLOSIONS_NBT_KEY = "maxExplosions";
    public static final String EXPLOSION_POWER_NBT_KEY = "explosionPower";
    public static final String INVERSE_EXPLOSION_DAMAGE_FACTOR_NBT_KEY = "inverseExplosionDamageFactor";
    public static final String FIRE_NBT_KEY = "createsFire";
    public static final String LANDED_KEY = "landed";
    public static final int DEFAULT_MAX_EXPLOSIONS = 5;
    public static final int DEFAULT_EXPLOSION_POWER = 10;
    public static final int DEFAULT_INVERSE_EXPLOSION_DAMAGE_FACTOR = 100;
    public static final boolean DEFAULT_FIRE_BOOLEAN_VALUE = false;
    public static final float DEFAULT_SCALE = 16.0f;
    public static final double DEFAULT_GRAVITY = 0.1;
    public static final class_5132 DEFAULT_ATTRIBUTES = class_5132.method_26861().method_26868(class_5134.field_47760, 16.0).method_26868(class_5134.field_49078, 0.1).method_26866();
    protected float prevScale = 0.0f;
    protected boolean shouldExplode = false;
    protected int explosionCounter = 0;
    protected class_243 explosionPos = class_243.field_1353;
    protected int maxExplosions = 5;
    protected float explosionPower = 10.0f;
    protected float inverseExplosionDamageFactor = 100.0f;
    protected boolean createsFire = false;
    private boolean landed = false;

    public TungstenRodEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    public TungstenRodEntity(class_1937 world, class_243 position) {
        this(RodsFromGodEntityTypes.TUNGSTEN_ROD, world);
        this.method_33574(position);
    }

    public void setMaxExplosions(int maxExplosions) {
        this.maxExplosions = maxExplosions;
    }

    public void setExplosionPower(float explosionPower) {
        this.explosionPower = explosionPower;
    }

    public void setInverseExplosionDamageFactor(float inverseExplosionDamageFactor) {
        this.inverseExplosionDamageFactor = inverseExplosionDamageFactor;
    }

    public void setCreatesFire(boolean createsFire) {
        this.createsFire = createsFire;
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(EXPLOSION_BOOLEAN_NBT_KEY)) {
            this.shouldExplode = nbt.method_10577(EXPLOSION_BOOLEAN_NBT_KEY);
        }
        if (nbt.method_10545(EXPLOSION_COUNTER_NBT_KEY)) {
            this.explosionCounter = nbt.method_10550(EXPLOSION_COUNTER_NBT_KEY);
        }
        if (nbt.method_10545(MAXIMUM_EXPLOSIONS_NBT_KEY)) {
            this.maxExplosions = nbt.method_10550(MAXIMUM_EXPLOSIONS_NBT_KEY);
        }
        if (nbt.method_10545(EXPLOSION_POWER_NBT_KEY)) {
            this.explosionPower = nbt.method_10583(EXPLOSION_POWER_NBT_KEY);
        }
        if (nbt.method_10545(INVERSE_EXPLOSION_DAMAGE_FACTOR_NBT_KEY)) {
            this.inverseExplosionDamageFactor = nbt.method_10583(INVERSE_EXPLOSION_DAMAGE_FACTOR_NBT_KEY);
        }
        if (nbt.method_10545(FIRE_NBT_KEY)) {
            this.createsFire = nbt.method_10577(FIRE_NBT_KEY);
        }
        if (nbt.method_10545(LANDED_KEY)) {
            this.landed = nbt.method_10577(LANDED_KEY);
        }
        try {
            if (nbt.method_10545(EXPLOSION_POS_NBT_KEY)) {
                class_2499 nbtList = nbt.method_10554(EXPLOSION_POS_NBT_KEY, 6);
                this.explosionPos = new class_243(class_3532.method_15350((double)nbtList.method_10611(0), (double)-3.0000512E7, (double)3.0000512E7), class_3532.method_15350((double)nbtList.method_10611(1), (double)-2.0E7, (double)2.0E7), class_3532.method_15350((double)nbtList.method_10611(2), (double)-3.0000512E7, (double)3.0000512E7));
            }
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Loading entity NBT");
            class_129 crashReportSection = crashReport.method_562("Entity being loaded");
            this.method_5819(crashReportSection);
            RodsFromGod.LOGGER.error("Error while loading Tungsten Rod Explosion Position", (Throwable)new class_148(crashReport));
            this.updateExplosionPos();
        }
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556(EXPLOSION_BOOLEAN_NBT_KEY, this.shouldExplode);
        nbt.method_10569(EXPLOSION_COUNTER_NBT_KEY, this.explosionCounter);
        nbt.method_10569(MAXIMUM_EXPLOSIONS_NBT_KEY, this.maxExplosions);
        nbt.method_10548(EXPLOSION_POWER_NBT_KEY, this.explosionPower);
        nbt.method_10548(INVERSE_EXPLOSION_DAMAGE_FACTOR_NBT_KEY, this.inverseExplosionDamageFactor);
        nbt.method_10556(FIRE_NBT_KEY, this.createsFire);
        nbt.method_10556(LANDED_KEY, this.landed);
        nbt.method_10566(EXPLOSION_POS_NBT_KEY, (class_2520)this.method_5846(new double[]{this.explosionPos.method_10216(), this.explosionPos.method_10214(), this.explosionPos.method_10215()}));
    }

    public void method_5773() {
        class_1937 world;
        float l;
        super.method_5773();
        if (this.method_5787()) {
            this.field_6007 = true;
            this.method_56990();
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.field_6037 = true;
        }
        if ((l = this.getScale()) != this.prevScale) {
            this.prevScale = l;
            this.method_18382();
        }
        if ((world = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.method_5782()) {
                this.method_5772();
            }
            if (this.field_36331 || this.method_24828()) {
                this.shouldExplode = true;
                this.updateExplosionPos();
                this.landed = true;
            }
            if (this.shouldExplode) {
                this.explode(serverWorld);
            }
        }
    }

    public float getScale() {
        class_5131 attributeContainer = this.getAttributes();
        return attributeContainer == null ? 16.0f : (float)attributeContainer.method_26852(class_5134.field_47760);
    }

    protected void updateExplosionPos() {
        this.explosionPos = new class_243(this.method_19538().method_10216(), this.method_19538().method_10214(), this.method_19538().method_10215());
    }

    protected double method_7490() {
        class_5131 attributeContainer = this.getAttributes();
        return attributeContainer == null ? 0.1 : attributeContainer.method_26852(class_5134.field_49078);
    }

    protected void explode(class_3218 serverWorld) {
        if (!this.shouldExplode) {
            return;
        }
        MinecraftServer server = serverWorld.method_8503();
        int ticks = server.method_3780();
        class_1928 gameRules = serverWorld.method_8450();
        class_1937.class_7867 sourceType = (class_1937.class_7867)((EnumRule)gameRules.method_20746(RodsFromGodGameRules.KINETIC_EXPLOSION_SOURCE_TYPE)).get();
        class_1282 source = new class_1282((class_6880)serverWorld.atmospheric_api$getEntryFromKey(class_7924.field_42534, RodsFromGodDamageTypes.KINETIC_EXPLOSION), (class_1297)this);
        class_5362 lessDamageExplosionBehavior = new class_5362(){

            public float method_55115(class_1927 explosion, class_1297 entity) {
                return super.method_55115(explosion, entity) / Math.max(1.0f, TungstenRodEntity.this.inverseExplosionDamageFactor);
            }

            public float method_57007(class_1297 entity) {
                return entity instanceof TungstenRodEntity || entity instanceof RodLandingMarkerEntity ? 0.0f : super.method_57007(entity);
            }
        };
        if (this.explosionCounter == 0) {
            serverWorld.method_8454((class_1297)this, source, lessDamageExplosionBehavior, this.explosionPos.method_10216(), this.explosionPos.method_10214(), this.explosionPos.method_10215(), this.explosionPower, this.createsFire && gameRules.method_8355(RodsFromGodGameRules.KINETIC_EXPLOSION_CAN_MAKE_FIRE), sourceType, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, RodsFromGodSoundEvents.TUNGSTEN_ROD_KINETIC_EXPLOSION);
        } else {
            serverWorld.method_8454((class_1297)this, source, lessDamageExplosionBehavior, this.explosionPos.method_10216(), this.explosionPos.method_10214(), this.explosionPos.method_10215(), this.explosionPower, false, sourceType, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, RodsFromGodSoundEvents.TUNGSTEN_ROD_KINETIC_EXPLOSION);
        }
        ++this.explosionCounter;
        if (this.explosionCounter >= this.maxExplosions) {
            this.method_31472();
        }
        if (this.explosionCounter > 1) {
            this.method_5648(true);
        }
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5659(class_1927 explosion) {
        return true;
    }

    public final class_4048 method_18377(class_4050 pose) {
        return this.getBaseDimensions(pose).method_18383(this.getScale());
    }

    protected class_4048 getBaseDimensions(class_4050 pose) {
        return this.method_5864().method_18386();
    }

    public class_5132 getDefaultAttributeContainer() {
        return DEFAULT_ATTRIBUTES;
    }

    public boolean hasLanded() {
        return this.landed;
    }
}

