/*
 * Decompiled with CFR 0.152.
 */
package survivalblock.rods_from_god.common.init;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import survivalblock.rods_from_god.common.RodsFromGod;
import survivalblock.rods_from_god.common.component.cca.entity.StoneStatueComponent;
import survivalblock.rods_from_god.common.component.cca.world.WasDayComponent;
import survivalblock.rods_from_god.common.component.cca.world.WorldLeverComponent;
import survivalblock.rods_from_god.common.init.RodsFromGodEntityComponents;
import survivalblock.rods_from_god.common.init.RodsFromGodWorldComponents;

public class RodsFromGodCommands {
    public static final DynamicCommandExceptionType STATUE_ENTITY_NOT_SUPPORTED = new DynamicCommandExceptionType(obj -> class_2561.method_54159((String)"argument.rodsfromgod.medusastatue.entity_not_supported", (Object[])new Object[]{obj}));
    public static final SimpleCommandExceptionType NOT_PLAYER_SOURCE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.rodsfromgod.notplayersource"));
    public static final SimpleCommandExceptionType ILLEGAL_EXECUTE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.rodsfromgod.illegalexecute"));

    public static void init(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralCommandNode rodsFromGodNode = class_2170.method_9247((String)"rodsfromgod").build();
        LiteralCommandNode worldLeverNode = class_2170.method_9247((String)"worldlever").build();
        LiteralCommandNode setLiftedNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setLifted").requires(source -> source.method_9259(2))).then((CommandNode)((RequiredArgumentBuilder)class_2170.method_9244((String)"lifted", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            class_1297 patt0$temp = source.method_9228();
            if (!(patt0$temp instanceof class_3222)) {
                throw NOT_PLAYER_SOURCE.create();
            }
            class_3222 serverPlayer = (class_3222)patt0$temp;
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            class_2960 id = RodsFromGodCommands.getIdFromServerWorld(serverWorld);
            boolean lifted = BoolArgumentType.getBool((CommandContext)context, (String)"lifted");
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_54159((String)"commands.rodsfromgod.worldlever.setlifted.success", (Object[])new Object[]{id, lifted}), true);
            RodsFromGod.LOGGER.info("Player {} set the value of lifted in the World Lever Component to {} for dimension {}", new Object[]{serverPlayer, lifted, id});
            return ((WorldLeverComponent)RodsFromGodWorldComponents.WORLD_LEVER.get((Object)serverWorld)).setLifted(lifted) ? 1 : 0;
        })).build())).build();
        LiteralCommandNode queryNode = class_2170.method_9247((String)"query").build();
        LiteralCommandNode isSwitchingNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"switching").executes(context -> {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            class_2960 id = RodsFromGodCommands.getIdFromServerWorld(serverWorld);
            boolean switching = ((WorldLeverComponent)RodsFromGodWorldComponents.WORLD_LEVER.get((Object)serverWorld)).isSwitching();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_54159((String)(switching ? "commands.rodsfromgod.worldlever.query.switching.true" : "commands.rodsfromgod.worldlever.query.switching.false"), (Object[])new Object[]{id}), true);
            return 1;
        })).build();
        LiteralCommandNode liftedNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"lifted").executes(context -> {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            class_2960 id = RodsFromGodCommands.getIdFromServerWorld(serverWorld);
            boolean lifted = ((WorldLeverComponent)RodsFromGodWorldComponents.WORLD_LEVER.get((Object)serverWorld)).isLifted();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_54159((String)(lifted ? "commands.rodsfromgod.worldlever.query.lifted.true" : "commands.rodsfromgod.worldlever.query.lifted.false"), (Object[])new Object[]{id}), true);
            return 1;
        })).build();
        LiteralCommandNode canSwitchNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"canSwitch").executes(context -> {
            class_3218 serverWorld = ((class_2168)context.getSource()).method_9225();
            class_2960 id = RodsFromGodCommands.getIdFromServerWorld(serverWorld);
            boolean canSwitch = ((WorldLeverComponent)RodsFromGodWorldComponents.WORLD_LEVER.get((Object)serverWorld)).canSwitch(serverWorld);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_54159((String)(canSwitch ? "commands.rodsfromgod.worldlever.query.canswitch.true" : "commands.rodsfromgod.worldlever.query.canswitch.false"), (Object[])new Object[]{id}), true);
            return 1;
        })).build();
        LiteralCommandNode medusaStatueNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"medusastatue").requires(source -> source.method_9259(2))).then((CommandNode)((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9309()).executes(RodsFromGodCommands::executeMedusaCurse)).build())).build();
        LiteralCommandNode lightningVolumeNode = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lightningvolume").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3218 serverWorld = source.method_9225();
            source.method_9226(() -> class_2561.method_54159((String)"commands.rodsfromgod.lightningvolume.get", (Object[])new Object[]{RodsFromGodCommands.getIdFromServerWorld(serverWorld), Float.valueOf(((WasDayComponent)RodsFromGodWorldComponents.WAS_DAY.get((Object)serverWorld)).getLightningVolume())}), false);
            return 1;
        })).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(source -> source.method_9259(2))).executes(ctx -> RodsFromGodCommands.executeSetLightningVolume((class_2168)ctx.getSource(), 10000.0f))).then(class_2170.method_9244((String)"value", (ArgumentType)FloatArgumentType.floatArg((float)2.0f, (float)10000.0f)).executes(ctx -> RodsFromGodCommands.executeSetLightningVolume((class_2168)ctx.getSource(), FloatArgumentType.getFloat((CommandContext)ctx, (String)"value"))))).build())).build();
        dispatcher.getRoot().addChild((CommandNode)rodsFromGodNode);
        rodsFromGodNode.addChild((CommandNode)worldLeverNode);
        worldLeverNode.addChild((CommandNode)setLiftedNode);
        worldLeverNode.addChild((CommandNode)queryNode);
        queryNode.addChild((CommandNode)liftedNode);
        queryNode.addChild((CommandNode)canSwitchNode);
        queryNode.addChild((CommandNode)isSwitchingNode);
        rodsFromGodNode.addChild((CommandNode)medusaStatueNode);
        rodsFromGodNode.addChild((CommandNode)lightningVolumeNode);
    }

    private static int executeMedusaCurse(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_5250 text;
        class_1297 entity = class_2186.method_9313(context, (String)"target");
        Optional optional = RodsFromGodEntityComponents.STONE_STATUE.maybeGet((Object)entity);
        class_2561 name = entity.method_5477();
        if (optional.isEmpty()) {
            throw STATUE_ENTITY_NOT_SUPPORTED.create((Object)name);
        }
        StoneStatueComponent stoneStatueComponent = (StoneStatueComponent)optional.get();
        if (stoneStatueComponent.showcase()) {
            stoneStatueComponent.setInStone(false, true);
            text = class_2561.method_54159((String)"commands.rodsfromgod.medusastatue.remove_statue", (Object[])new Object[]{name});
        } else {
            stoneStatueComponent.setInStone(true, true);
            text = class_2561.method_54159((String)"commands.rodsfromgod.medusastatue.set_statue", (Object[])new Object[]{name});
        }
        ((class_2168)context.getSource()).method_9226(() -> RodsFromGodCommands.lambda$executeMedusaCurse$16((class_2561)text), true);
        return 1;
    }

    public static class_2960 getIdFromServerWorld(class_3218 serverWorld) {
        MinecraftServer server = serverWorld.method_8503();
        return server.method_29435().stream().collect(Collectors.toMap(arg_0 -> ((MinecraftServer)server).method_3847(arg_0), class_5321::method_29177)).get(serverWorld);
    }

    private static int executeSetLightningVolume(class_2168 source, float newVolume) {
        class_3218 serverWorld = source.method_9225();
        WasDayComponent wasDayComponent = (WasDayComponent)RodsFromGodWorldComponents.WAS_DAY.get((Object)serverWorld);
        float oldVolume = wasDayComponent.getLightningVolume();
        wasDayComponent.setLightningVolume(newVolume);
        source.method_9226(() -> class_2561.method_54159((String)"commands.rodsfromgod.lightningvolume.set", (Object[])new Object[]{RodsFromGodCommands.getIdFromServerWorld(serverWorld), Float.valueOf(oldVolume), Float.valueOf(newVolume)}), true);
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$executeMedusaCurse$16(class_2561 text) {
        return text;
    }
}

