/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlockType;
import com.yuushya.block.LineBlock;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.block.blockstate.ConnectedHorizonState;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.utils.YuushyaUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LineCrossBlock
extends AbstractYuushyaBlockType {
    @Override
    public List<Property<?>> getBlockStateProperty() {
        return List.of(BlockStateProperties.f_61374_, YuushyaBlockStates.POS_HORIZON, YuushyaBlockStates.FRONT, YuushyaBlockStates.BACK);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        BlockState res = blockPlaceContext.m_43719_().m_122434_() == Direction.Axis.Y ? (BlockState)this.defaultBlockState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_8125_()) : (BlockState)this.defaultBlockState().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)blockPlaceContext.m_43719_().m_122424_());
        return (BlockState)((BlockState)((BlockState)res.m_61124_(YuushyaBlockStates.POS_HORIZON, (Comparable)((Object)LineBlock.getPositionOfFace(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_(), LineCrossBlock::isConnected)))).m_61124_(YuushyaBlockStates.FRONT, (Comparable)((Object)LineCrossBlock.getFrontState(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())))).m_61124_(YuushyaBlockStates.BACK, (Comparable)((Object)LineCrossBlock.getBackState(res, (LevelAccessor)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())));
    }

    @Override
    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        BlockState res = (BlockState)blockState.m_61124_(YuushyaBlockStates.POS_HORIZON, (Comparable)((Object)LineBlock.getPositionOfFace(blockState, levelAccessor, blockPos, LineCrossBlock::isConnected)));
        return direction.m_122434_().m_122479_() ? (BlockState)((BlockState)res.m_61124_(YuushyaBlockStates.FRONT, (Comparable)((Object)LineCrossBlock.getFrontState(res, levelAccessor, blockPos)))).m_61124_(YuushyaBlockStates.BACK, (Comparable)((Object)LineCrossBlock.getBackState(res, levelAccessor, blockPos))) : res;
    }

    public static ConnectedHorizonState getFrontState(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facingDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState facingBlock = level.m_8055_(pos.m_121945_(facingDirection));
        if (YuushyaBlockFactory.isTheSameBlock(state, facingBlock)) {
            Direction direction = (Direction)facingBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            if (facingDirection == direction.m_122427_()) {
                return ConnectedHorizonState.LEFT;
            }
            if (facingDirection == direction.m_122428_()) {
                return ConnectedHorizonState.RIGHT;
            }
        }
        return ConnectedHorizonState.NONE;
    }

    public static ConnectedHorizonState getBackState(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction facingDirection = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        BlockState backBlock = YuushyaUtils.getBlockState(level.m_8055_(pos.m_121945_(facingDirection.m_122424_())), level, pos.m_121945_(facingDirection.m_122424_()));
        if (YuushyaBlockFactory.isTheSameBlock(state, backBlock)) {
            Direction direction = (Direction)backBlock.m_61143_((Property)BlockStateProperties.f_61374_);
            if (facingDirection == direction.m_122427_()) {
                return ConnectedHorizonState.LEFT;
            }
            if (facingDirection == direction.m_122428_()) {
                return ConnectedHorizonState.RIGHT;
            }
        }
        return ConnectedHorizonState.NONE;
    }

    public static boolean isConnected(BlockState state1, BlockState curState) {
        return YuushyaBlockFactory.isTheSameFacing(state1, curState) || YuushyaBlockFactory.isPerpendicular(state1, curState);
    }
}

