/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaModelUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CollisionFileReader {
    private static Map<String, Map<String, VoxelShape>> collisionMap = new HashMap<String, Map<String, VoxelShape>>();
    public static Path COLLISION_FILES = Platform.getConfigFolder().resolve("./com.yuushya/");
    private static final Map<VoxelShape, VoxelShape> RESTRICT_SHAPE_MAP = new HashMap<VoxelShape, VoxelShape>();

    @Deprecated
    public static void readAllFileSelf() {
        Set<String> set = YuushyaRegistries.BlockALL.keySet();
        for (String name : set) {
            try {
                InputStream inputStream = CollisionFileReader.class.getResourceAsStream("/data/yuushya/collision/" + name + ".json");
                try {
                    JsonElement jsonElement;
                    CollisionItem collision;
                    if (inputStream == null || (collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(inputStream))), CollisionItem.class)) == null || collision.blockstates == null) continue;
                    HashMap<String, VoxelShape> map = new HashMap<String, VoxelShape>();
                    for (CollisionItem.Model variant : collision.blockstates) {
                        map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                    }
                    CollisionFileReader.getCollisionMap().put(new ResourceLocation("yuushya", name).toString(), map);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, map);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static void readAllFileFromConfig() {
        if (Files.exists(COLLISION_FILES, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(COLLISION_FILES);){
                for (Path path : paths) {
                    String namespace = path.getFileName().toString();
                    Path newPath = path.resolve("./data/" + namespace + "/collision/");
                    DirectoryStream<Path> collisionFiles = Files.newDirectoryStream(newPath);
                    try {
                        for (Path collisionFile : collisionFiles) {
                            String id = collisionFile.getFileName().toString().replace(".json", "");
                            if (!Files.exists(collisionFile, new LinkOption[0])) continue;
                            try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new FileReader(collisionFile.toFile(), StandardCharsets.UTF_8)));){
                                CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(JsonParser.parseReader((JsonReader)reader), CollisionItem.class);
                                if (collision == null || collision.blockstates == null) continue;
                                HashMap<String, VoxelShape> map = new HashMap<String, VoxelShape>();
                                for (CollisionItem.Model variant : collision.blockstates) {
                                    map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                                }
                                CollisionFileReader.getCollisionMap().put(new ResourceLocation(namespace, id).toString(), map);
                                if (collision.children == null) continue;
                                for (String namespaceId : collision.children) {
                                    CollisionFileReader.getCollisionMap().put(namespaceId, map);
                                }
                            }
                        }
                    }
                    finally {
                        if (collisionFiles == null) continue;
                        collisionFiles.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllCollision() {
        if (YuushyaBlockFactory.getYuushyaVoxelShapes().isEmpty()) {
            CollisionFileReader.getCollisionMap().forEach((key, value) -> CollisionFileReader.readCollisionToVoxelShape(key));
        }
    }

    public static void readCollisionToVoxelShape(BlockState blockState, String namespaceid) {
        Map<String, VoxelShape> collision;
        if (!(blockState.m_60734_() instanceof AirBlock) && (collision = CollisionFileReader.getCollisionMap().get(namespaceid)) != null) {
            for (String variant : collision.keySet()) {
                if (!YuushyaModelUtils.isBlockStateInVariantString(blockState, variant)) continue;
                VoxelShape shape = collision.get(variant);
                String id = blockState.toString();
                YuushyaBlockFactory.getYuushyaVoxelShapes().put(id, shape);
                YuushyaBlockFactory.getYuushyaCollisionShapes().put(id, CollisionFileReader.restrictShape(shape));
            }
        }
    }

    public static void readCollisionToVoxelShape(String namespaceid) {
        Block block;
        Map<String, VoxelShape> collision = CollisionFileReader.getCollisionMap().get(namespaceid);
        if (collision != null && !((block = (Block)Registry.f_122824_.m_7745_(new ResourceLocation(namespaceid))) instanceof AirBlock)) {
            for (Map.Entry<String, VoxelShape> entry : collision.entrySet()) {
                String variant = entry.getKey();
                VoxelShape shape = entry.getValue();
                List<BlockState> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant);
                for (BlockState blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(blockstate.toString(), shape);
                    YuushyaBlockFactory.getYuushyaCollisionShapes().put(blockstate.toString(), CollisionFileReader.restrictShape(shape));
                }
            }
        }
    }

    public static VoxelShape getVoxelShape(CollisionItem.Model model) {
        VoxelShape shape = Shapes.m_83040_();
        if (model.collision == null) {
            return Shapes.m_83144_();
        }
        for (CollisionItem.Model.Element cube : model.collision) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Block.m_49796_((double)cube.from.get(0), (double)cube.from.get(1), (double)cube.from.get(2), (double)cube.to.get(0), (double)cube.to.get(1), (double)cube.to.get(2)));
        }
        if ((shape = shape.m_83296_()).m_83281_()) {
            return Shapes.m_83144_();
        }
        return shape;
    }

    public static VoxelShape restrictShape(VoxelShape shape) {
        if (RESTRICT_SHAPE_MAP.containsKey(shape)) {
            return RESTRICT_SHAPE_MAP.get(shape);
        }
        VoxelShape res = Shapes.m_83040_();
        for (AABB aabb : shape.m_83299_()) {
            VoxelShape one = Shapes.m_166049_((double)Math.max(0.0, aabb.f_82288_), (double)Math.max(0.0, aabb.f_82289_), (double)Math.max(0.0, aabb.f_82290_), (double)Math.min(1.0, aabb.f_82291_), (double)Math.min(1.5, aabb.f_82292_), (double)Math.min(1.0, aabb.f_82293_));
            res = Shapes.m_83110_((VoxelShape)res, (VoxelShape)one);
        }
        res = res.m_83296_();
        RESTRICT_SHAPE_MAP.put(shape, res);
        return res;
    }

    public static Map<String, Map<String, VoxelShape>> getCollisionMap() {
        return collisionMap;
    }

    public static void setCollisionMap(Map<String, Map<String, VoxelShape>> collisionMap) {
        CollisionFileReader.collisionMap = collisionMap;
    }
}

