/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.entity;

import com.yuushya.entity.ChairEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ChairEntityUtils {
    public static boolean isLivingEntitySittingOnPos(LevelAccessor world, BlockPos pos) {
        return ChairEntityUtils.isLivingEntitySittingOnPos(world, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static boolean isLivingEntitySittingOnPos(LevelAccessor world, double posX, double posY, double posZ) {
        List list = world.m_45976_(ChairEntity.class, new AABB(posX + 0.0625, posY, posZ + 0.0625, posX + 0.9375, posY + 1.5, posZ + 0.9375));
        return list.size() != 0;
    }

    @Nullable
    public static ChairEntity sitToChair(LivingEntity entity, Vec3 pos, boolean sendMessage) {
        return ChairEntityUtils.sitToChair(entity, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), sendMessage);
    }

    public static ChairEntity sitToChair(LivingEntity entity, double x, double y, double z, boolean sendMessage) {
        if (!entity.m_6084_()) {
            return null;
        }
        if (ChairEntityUtils.isLivingEntitySittingOnPos((LevelAccessor)entity.f_19853_, x, y, z)) {
            if (!sendMessage || entity instanceof Player) {
                // empty if block
            }
            return null;
        }
        ChairEntity chair = new ChairEntity(entity.f_19853_, x, y, z);
        entity.f_19853_.m_7967_((Entity)chair);
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        entity.m_20329_((Entity)chair);
        return chair;
    }

    public static ChairEntity sitToChair(LivingEntity entity) {
        return ChairEntityUtils.sitToChair(entity, entity.m_20182_(), true);
    }

    public static boolean isValidityLocation(LevelAccessor world, Vec3 pos, Pose passengersPose) {
        return ChairEntityUtils.isValidityLocation(world, new BlockPos(Math.floor(pos.m_7096_()), Math.floor(pos.m_7098_() - 0.03), Math.floor(pos.m_7094_())), passengersPose);
    }

    public static boolean isValidityLocation(LevelAccessor world, BlockPos pos, Pose passengersPose) {
        return !world.m_8055_(pos).m_60767_().equals(Material.f_76296_) && (passengersPose.equals((Object)Pose.STANDING) || passengersPose.equals((Object)Pose.CROUCHING));
    }

    public static boolean isValidityLocation(LivingEntity entity) {
        return entity.m_20096_() && ChairEntityUtils.isValidityLocation((LevelAccessor)entity.f_19853_, entity.m_20182_(), entity.m_20089_());
    }

    public static InteractionResult use(Vec3 sitPos, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            Direction facing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : (state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.NORTH);
            RotatePos.RotateAngle ra = RotatePos.RotateAngle.get(facing.m_122416_() - Direction.NORTH.m_122416_() & 3);
            double[] rotate = RotatePos.rotate(sitPos.m_7094_(), sitPos.m_7096_(), 0.5, ra);
            if (!ChairEntityUtils.isLivingEntitySittingOnPos((LevelAccessor)level, pos)) {
                ChairEntityUtils.sitToChair((LivingEntity)player, (double)pos.m_123341_() + rotate[0], (double)pos.m_123342_() + sitPos.m_7098_(), (double)pos.m_123343_() + rotate[1], false);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static class RotatePos {
        public static double[] rotate(double x, double z, double center, RotateAngle rotate) {
            double[] ret = new double[2];
            double lx = x - center;
            double lz = z - center;
            switch (rotate.ordinal()) {
                case 1: {
                    ret[0] = -lz;
                    ret[1] = lx;
                    break;
                }
                case 2: {
                    ret[0] = -lx;
                    ret[1] = -lz;
                    break;
                }
                case 3: {
                    ret[0] = lz;
                    ret[1] = -lx;
                    break;
                }
                case 0: {
                    ret[0] = lx;
                    ret[1] = lz;
                }
            }
            ret[0] = ret[0] + center;
            ret[1] = ret[1] + center;
            return ret;
        }

        public static float[] rotate(float x, float z, float center, RotateAngle rotate) {
            float[] ret = new float[2];
            float lx = x - center;
            float lz = z - center;
            switch (rotate.ordinal()) {
                case 1: {
                    ret[0] = -lz;
                    ret[1] = lx;
                    break;
                }
                case 2: {
                    ret[0] = -lx;
                    ret[1] = -lz;
                    break;
                }
                case 3: {
                    ret[0] = lz;
                    ret[1] = -lx;
                    break;
                }
                case 0: {
                    ret[0] = lx;
                    ret[1] = lz;
                }
            }
            ret[0] = ret[0] + center;
            ret[1] = ret[1] + center;
            return ret;
        }

        public static int[] rotate(int x, int z, int center, RotateAngle rotate) {
            int[] ret = new int[2];
            int lx = x - center;
            int lz = z - center;
            switch (rotate.ordinal()) {
                case 1: {
                    ret[0] = -lz;
                    ret[1] = lx;
                    break;
                }
                case 2: {
                    ret[0] = -lx;
                    ret[1] = -lz;
                    break;
                }
                case 3: {
                    ret[0] = lz;
                    ret[1] = -lx;
                    break;
                }
                case 0: {
                    ret[0] = lx;
                    ret[1] = lz;
                }
            }
            ret[0] = ret[0] + center;
            ret[1] = ret[1] + center;
            return ret;
        }

        public static enum RotateAngle {
            R0(0),
            R90(1),
            R180(2),
            R270(3);

            public final int id;

            private RotateAngle(int id) {
                this.id = id;
            }

            public static RotateAngle get(int id) {
                return switch (id) {
                    case 1 -> R90;
                    case 2 -> R180;
                    case 3 -> R270;
                    default -> R0;
                };
            }
        }
    }
}

