/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yuushya.registries.YuushyaConfig;
import com.yuushya.utils.CheckFileUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CheckScreen
extends Screen {
    private static final Component TITLE = Component.m_237115_((String)"gui.yuushya.checkScreen.header").m_130940_(ChatFormatting.BOLD);
    private static final Component RESOURCEPACK = Component.m_237115_((String)"gui.yuushya.checkScreen.resourcepack").m_130940_(ChatFormatting.RED);
    private static final Component RECOMMEND = Component.m_237115_((String)"gui.yuushya.checkScreen.recommend").m_130940_(ChatFormatting.RED);
    private static final Component CTM = Component.m_237115_((String)"gui.yuushya.checkScreen.ctm").m_130940_(ChatFormatting.RED);
    private static final Component CHECK = Component.m_237115_((String)"multiplayerWarning.check");
    private static final Component MESSAGE = Component.m_237115_((String)"gui.yuushya.checkScreen.message");
    private static final Component CONGRATULATIONS = Component.m_237115_((String)"gui.yuushya.checkScreen.congratulations");
    private Component message;
    private static final Component NARRATION = TITLE.m_6881_().m_130946_("\n").m_7220_(MESSAGE);
    private final Screen previous;
    private static final int MESSAGE_PADDING = 100;
    protected Checkbox stopShowing;
    protected Button finishButton;
    private final List<InfoPanel> resourcepackPanel = new ArrayList<InfoPanel>();
    private final List<InfoPanel> recommendPanel = new ArrayList<InfoPanel>();
    private final List<InfoPanel> ctmPanel = new ArrayList<InfoPanel>();
    private int resourcepackY;
    private int recommendY;
    private int ctmY;

    public static MutableComponent componentEmpty() {
        return Component.m_237113_((String)"");
    }

    public CheckScreen(Screen previous) {
        super(TITLE);
        this.previous = previous;
    }

    public int center(int width) {
        return (this.f_96543_ - width) / 2;
    }

    protected void m_7856_() {
        InfoPanel infoPanel;
        int yCurrent = 45;
        Objects.requireNonNull(this.f_96547_);
        this.resourcepackY = yCurrent - 9;
        for (CheckFileUtils.Info info : CheckFileUtils.checkResourcePacks()) {
            infoPanel = new InfoPanel(info, this.f_96547_, 20, yCurrent);
            infoPanel.init(this);
            this.resourcepackPanel.add(infoPanel);
            Objects.requireNonNull(this.f_96547_);
            yCurrent += 2 * 9;
        }
        Objects.requireNonNull(this.f_96547_);
        this.recommendY = yCurrent + 9;
        Objects.requireNonNull(this.f_96547_);
        yCurrent += 2 * 9;
        for (CheckFileUtils.Info info : CheckFileUtils.checkRecommend()) {
            infoPanel = new InfoPanel(info, this.f_96547_, 20, yCurrent);
            infoPanel.init(this);
            this.recommendPanel.add(infoPanel);
            Objects.requireNonNull(this.f_96547_);
            yCurrent += 2 * 9;
        }
        Objects.requireNonNull(this.f_96547_);
        this.ctmY = yCurrent + 9;
        Objects.requireNonNull(this.f_96547_);
        yCurrent += 2 * 9;
        for (CheckFileUtils.Info info : CheckFileUtils.checkCTM()) {
            infoPanel = new InfoPanel(info, this.f_96547_, 20, yCurrent);
            infoPanel.init(this);
            this.ctmPanel.add(infoPanel);
            Objects.requireNonNull(this.f_96547_);
            yCurrent += 2 * 9;
        }
        this.message = this.resourcepackPanel.isEmpty() && this.recommendPanel.isEmpty() && this.ctmPanel.isEmpty() ? CONGRATULATIONS : MESSAGE;
        this.stopShowing = new Checkbox(this.f_96543_ / 4 - 30, this.f_96544_ - 35, this.f_96547_.m_92852_((FormattedText)CHECK), 20, CHECK, false);
        this.finishButton = new Button(this.f_96543_ / 4 * 3 - 60, this.f_96544_ - 35, 120, 20, CommonComponents.f_130659_, button -> {
            if (this.stopShowing.m_93840_()) {
                YuushyaConfig.CLIENT_CONFIG.check = false;
                YuushyaConfig.CLIENT_CONFIG.update();
            }
            this.f_96541_.m_91152_(this.previous);
        });
        this.m_142416_((GuiEventListener)this.stopShowing);
        this.m_142416_((GuiEventListener)this.finishButton);
    }

    public Component m_142562_() {
        return NARRATION;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.previous);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        CheckScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)TITLE, (int)this.center(this.f_96547_.m_92852_((FormattedText)TITLE)), (int)10, (int)0xFFFFFF);
        CheckScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.message, (int)this.center(this.f_96547_.m_92852_((FormattedText)this.message)), (int)23, (int)0xFFFFFF);
        if (!this.resourcepackPanel.isEmpty()) {
            CheckScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)RESOURCEPACK, (int)0, (int)this.resourcepackY, (int)0xFFFFFF);
        }
        if (!this.recommendPanel.isEmpty()) {
            CheckScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)RECOMMEND, (int)0, (int)this.recommendY, (int)0xFFFFFF);
        }
        if (!this.ctmPanel.isEmpty()) {
            CheckScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)CTM, (int)0, (int)this.ctmY, (int)0xFFFFFF);
        }
        this.resourcepackPanel.forEach(panel -> panel.render(poseStack, mouseX, mouseY, partialTick));
        this.recommendPanel.forEach(panel -> panel.render(poseStack, mouseX, mouseY, partialTick));
        this.ctmPanel.forEach(panel -> panel.render(poseStack, mouseX, mouseY, partialTick));
    }

    public static class InfoPanel {
        private final CheckFileUtils.Info info;
        private final List<Button> links = new ArrayList<Button>();
        private final Font font;
        public final int x;
        public final int y;
        private final MutableComponent descriptionLine;
        private static final MutableComponent link = Component.m_237115_((String)"gui.yuushya.checkScreen.link").m_7220_((Component)Component.m_237113_((String)" : "));

        public InfoPanel(CheckFileUtils.Info info, Font font, int x, int y) {
            this.info = info;
            this.font = font;
            this.x = x;
            this.y = y;
            this.descriptionLine = CheckScreen.componentEmpty().m_7220_((Component)Component.m_237115_((String)("gui.yuushya.checkScreen.name." + info.id())).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)" : ")).m_7220_((Component)Component.m_237115_((String)("gui.yuushya.checkScreen.description." + info.id())));
        }

        public void init(CheckScreen screen) {
            int widthCurrent = this.font.m_92852_((FormattedText)link);
            Objects.requireNonNull(this.font);
            int yCurrent = this.y + 9;
            for (Map.Entry<String, String> entry : this.info.link().entrySet()) {
                String text = entry.getKey();
                String url = entry.getValue();
                int widthText = this.font.m_92895_(text);
                Objects.requireNonNull(this.font);
                this.links.add((Button)new PlainTextButton(this.x + widthCurrent, yCurrent, widthText, 9, (Component)Component.m_237113_((String)text), button -> Util.m_137581_().m_137648_(URI.create(url)), this.font));
                widthCurrent += widthText + 10;
            }
            this.links.forEach(x$0 -> {
                Button cfr_ignored_0 = (Button)screen.m_142416_(x$0);
            });
        }

        public void render(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.font, (Component)this.descriptionLine, (int)this.x, (int)this.y, (int)0xFFFFFF);
            Objects.requireNonNull(this.font);
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.font, (Component)link, (int)this.x, (int)(this.y + 9), (int)0xFFFFFF);
        }
    }
}

