/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.yuushya.registries.YuushyaRegistries;
import dev.architectury.registry.CreativeTabRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class YuushyaCreativeModeTab {
    private static final Map<String, CreativeModeTab> TABS = new HashMap<String, CreativeModeTab>();
    public static final CreativeModeTab YUUSHYA_ITEM = YuushyaCreativeModeTab.create("item", () -> YuushyaRegistries.ITEMS.getInstanceOrDefault("form_trans_item", Items.f_42410_));

    private YuushyaCreativeModeTab() {
    }

    public static CreativeModeTab create(String name, Supplier<Item> item) {
        if (!TABS.containsKey(name)) {
            TABS.put(name, CreativeTabRegistry.create((ResourceLocation)new ResourceLocation("yuushya", name), () -> new ItemStack((ItemLike)item.get())));
        }
        return TABS.get(name);
    }

    public static void register(String name, String icon) {
        YuushyaCreativeModeTab.create(name, () -> {
            if (icon.contains(":")) {
                return (Item)Registry.f_122827_.m_7745_(ResourceLocation.m_135820_((String)icon));
            }
            return YuushyaRegistries.ITEMS.getInstanceOrDefault(icon, Items.f_42410_);
        });
    }

    public static CreativeModeTab toGroup(String creativeModeTab) {
        return TABS.getOrDefault(creativeModeTab, YUUSHYA_ITEM);
    }
}

