/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.registries;

import com.google.gson.JsonObject;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.entity.ChairEntity;
import com.yuushya.item.BlockUpdateItem;
import com.yuushya.item.FoodItem;
import com.yuushya.item.FormTransItem;
import com.yuushya.item.SetHatItem;
import com.yuushya.item.TemplateBlockItem;
import com.yuushya.item.TemplateChildBlockItem;
import com.yuushya.item.YuushyaItemFactory;
import com.yuushya.particle.YuushyaParticleBlock;
import com.yuushya.registries.YuushyaCreativeModeTab;
import com.yuushya.registries.YuushyaDeferredRegister;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaUtils;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MaterialColor;

public class YuushyaRegistries {
    public static final YuushyaDeferredRegister<Block> BLOCKS = new YuushyaDeferredRegister(Registry.f_122901_);
    public static final YuushyaDeferredRegister<Item> ITEMS = new YuushyaDeferredRegister(Registry.f_122904_);
    public static final YuushyaDeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = new YuushyaDeferredRegister(Registry.f_122907_);
    public static final YuushyaDeferredRegister<EntityType<?>> ENTITIES = new YuushyaDeferredRegister(Registry.f_122903_);
    public static final YuushyaDeferredRegister<ParticleType<?>> PARTICLE_TYPES = new YuushyaDeferredRegister(Registry.f_122906_);
    public static final Map<String, YuushyaRegistryData.Block> BlockALL = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockTemplate = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockDefault = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> BlockRemain = new HashMap<String, YuushyaRegistryData.Block>();
    public static final Map<String, YuushyaRegistryData.Block> TextureTypeMap = new LinkedHashMap<String, YuushyaRegistryData.Block>();
    public static RegistrySupplier<EntityType<?>> CHAIR_ENTITY = null;

    public static void registerRegistries() {
        for (YuushyaRegistryData.ItemGroup itemGroup : YuushyaRegistryConfig.YuushyaRawItemGroupMap.values()) {
            YuushyaCreativeModeTab.register(itemGroup.name, itemGroup.icon);
        }
        for (YuushyaRegistryData.Item item : YuushyaRegistryConfig.YuushyaRawItemMap.values()) {
            ITEMS.register(item.name, () -> YuushyaItemFactory.create(item));
        }
        block13: for (YuushyaRegistryData.Block block : YuushyaRegistryConfig.YuushyaRawBlockMap.values()) {
            switch (block.classType) {
                case "_comment": 
                case "class": {
                    continue block13;
                }
                case "remain": {
                    BlockRemain.put(block.name, block);
                    continue block13;
                }
                case "template": {
                    BlockTemplate.put(block.name, block);
                    continue block13;
                }
            }
            BlockDefault.put(block.name, block);
            if (block.classType.equals("block")) {
                if (block.renderType == null || block.renderType.isEmpty()) {
                    block.renderType = "cutout";
                }
                if (block.itemGroup == null) {
                    block.itemGroup = "extra_blocks";
                }
                if (block.texture == null) {
                    block.texture = new YuushyaRegistryData.Block.Texture();
                    block.texture.type = "all";
                }
            }
            if (block.texture == null || block.texture.type == null || block.texture.type.isEmpty()) continue;
            TextureTypeMap.put(block.name, block);
        }
        for (YuushyaRegistryData.Block blockRemain : BlockRemain.values()) {
            ResourceLocation blockResourceLocation = new ResourceLocation(blockRemain.name);
            if (blockRemain.texture == null) {
                blockRemain.texture = new YuushyaRegistryData.Block.Texture();
                blockRemain.texture.type = "all";
            }
            if (blockRemain.texture.value == null || blockRemain.texture.value.isEmpty()) {
                blockRemain.texture.value = new ResourceLocation(blockResourceLocation.m_135827_(), "block/" + blockResourceLocation.m_135815_()).toString();
            }
            if (blockRemain.texture.type == null || blockRemain.texture.type.isEmpty()) continue;
            TextureTypeMap.put(blockRemain.name, blockRemain);
        }
        for (YuushyaRegistryData.Block templateBlock : BlockTemplate.values()) {
            int lines = templateBlock.properties == null ? 1 : templateBlock.properties.lines;
            ITEMS.register(templateBlock.name, () -> new TemplateBlockItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(templateBlock.itemGroup)), lines, templateBlock.name));
        }
        for (YuushyaRegistryData.Block block : BlockDefault.values()) {
            BlockALL.put(block.name, block);
            BLOCKS.register(block.name, () -> YuushyaBlockFactory.create(block));
            if (block.properties != null && block.properties.food != null) {
                ITEMS.register(block.name, () -> new FoodItem((Block)BLOCKS.get(block.name).get(), block, new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(block.itemGroup))));
                continue;
            }
            ITEMS.register(block.name, () -> new BlockItem((Block)BLOCKS.get(block.name).get(), new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(block.itemGroup))));
        }
        for (YuushyaRegistryData.Block templateBlock : BlockTemplate.values()) {
            JsonObject templateBlockJson = GsonTools.NormalGSON.toJsonTree((Object)templateBlock, YuushyaRegistryData.Block.class).getAsJsonObject();
            List<YuushyaRegistryData.Block> list = YuushyaRegistries.getTemplateUsageList(templateBlock);
            for (YuushyaRegistryData.Block block : list) {
                String name;
                BlockBehaviour.Properties properties;
                JsonObject blockJson = GsonTools.NormalGSON.toJsonTree((Object)block, YuushyaRegistryData.Block.class).getAsJsonObject();
                YuushyaRegistryData.Block blockNew = GsonTools.combineYuushyaDataBlockJson(blockJson, templateBlockJson);
                blockNew.properties.parent = block.name;
                if (block.classType.equals("remain")) {
                    ResourceLocation blockResourceLocation = new ResourceLocation(block.name);
                    properties = YuushyaBlockFactory.getBlockProperties(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)Registry.f_122824_.m_7745_(blockResourceLocation))), blockNew.properties);
                    if (blockNew.properties != null) {
                        properties.m_155949_(YuushyaUtils.toMaterialColor(blockNew.properties.material));
                    } else {
                        properties.m_155949_(MaterialColor.f_76398_);
                    }
                    name = blockResourceLocation.m_135815_();
                } else {
                    properties = YuushyaBlockFactory.getBlockProperties(blockNew.properties);
                    name = block.name;
                }
                blockNew.name = templateBlock.name + "_" + name;
                blockNew.classType = "template:" + templateBlock.name;
                BLOCKS.register(blockNew.name, () -> YuushyaBlockFactory.create(properties, blockNew));
                ITEMS.register(blockNew.name, () -> new TemplateChildBlockItem((Block)BLOCKS.get(blockNew.name).get(), new Item.Properties(), block.classType, templateBlock.name, block.name));
                BlockALL.put(blockNew.name, blockNew);
            }
        }
        for (YuushyaRegistryData.Particle particle : YuushyaRegistryConfig.YuushyaRawParticleMap.values()) {
            if (particle.spawner == null) {
                particle.spawner = new YuushyaRegistryData.Block();
            }
            if (particle.spawner.properties == null) {
                particle.spawner.properties = new YuushyaRegistryData.Block.Properties();
            }
            if (particle.spawner.name == null || particle.spawner.name.isEmpty()) {
                particle.spawner.name = particle.name + "_spawner";
            }
            BLOCKS.register(particle.spawner.name, () -> new YuushyaParticleBlock(YuushyaBlockFactory.getBlockProperties(particle.spawner.properties), particle.spawner.properties.lines, "ParticleBlock", particle.spawner.usage, () -> (SimpleParticleType)PARTICLE_TYPES.get(particle.name).get()));
            ITEMS.register(particle.spawner.name, () -> new BlockItem((Block)BLOCKS.get(particle.spawner.name).get(), new Item.Properties().m_41491_(YuushyaCreativeModeTab.toGroup(particle.spawner.itemGroup))));
            PARTICLE_TYPES.register(particle.name, YuushyaParticleBlock.YuushyaParticleType::create);
        }
    }

    public static List<YuushyaRegistryData.Block> getTemplateUsageList(YuushyaRegistryData.Block templateBlock) {
        ArrayList<YuushyaRegistryData.Block> list = new ArrayList<YuushyaRegistryData.Block>();
        if (templateBlock.texture == null || templateBlock.texture.forClass == null && templateBlock.texture.forSpecified == null) {
            list.addAll(TextureTypeMap.values());
        } else {
            if (templateBlock.texture.forClass != null) {
                list.addAll(TextureTypeMap.values().stream().filter(e -> templateBlock.texture.forClass.contains(e.texture.type)).toList());
            }
            if (templateBlock.texture.forSpecified != null) {
                templateBlock.texture.forSpecified.forEach(name -> {
                    ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)name);
                    if (resourceLocation != null) {
                        if (TextureTypeMap.containsKey(resourceLocation.toString())) {
                            list.add(TextureTypeMap.get(resourceLocation.toString()));
                        }
                        if (TextureTypeMap.containsKey(resourceLocation.m_135815_())) {
                            list.add(TextureTypeMap.get(resourceLocation.m_135815_()));
                        }
                    }
                });
            }
        }
        return list;
    }

    public static void registerAll() {
        ITEMS.register("form_trans_item", () -> new FormTransItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.YUUSHYA_ITEM).m_41487_(1), 2));
        ITEMS.register("blockstate_update_item", () -> new BlockUpdateItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.YUUSHYA_ITEM).m_41487_(1), 2));
        ITEMS.register("pilatory", () -> new SetHatItem(new Item.Properties().m_41491_(YuushyaCreativeModeTab.YUUSHYA_ITEM).m_41487_(64), 2));
        CHAIR_ENTITY = ENTITIES.register("ride_entity", () -> EntityType.Builder.m_20704_(ChairEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.02f).m_20712_("ride_entity"));
    }

    public static void registerClient() {
        BlockALL.values().forEach(block -> {
            RenderTypeRegistry.register((RenderType)YuushyaUtils.toRenderType(block.renderType), (Block[])new Block[]{(Block)BLOCKS.get(block.name).get()});
            if (block.colorTint != null && block.colorTint.colorType != null && !block.colorTint.colorType.isEmpty() && !block.colorTint.colorType.equals("null")) {
                ColorHandlerRegistry.registerBlockColors((BlockColor)YuushyaUtils.toBlockColor(block.colorTint.colorType, block.colorTint.colorString), (Supplier[])new Supplier[]{BLOCKS.get(block.name)});
            }
        });
    }
}

