/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AddonLoader {
    private static final Predicate<Path> ADDON_FILTER = path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".yuushya.jar");
    private static final Predicate<ResourceLocation> JSON_FILTER = resourceLocation -> resourceLocation.m_135815_().endsWith(".json");
    private static final FallbackResourceManager YUUSHYA_MANAGER = new FallbackResourceManager(PackType.SERVER_DATA, "yuushya");

    private static Path classJarPath(String modId, Class<?> ... clazz) {
        List paths;
        if (modId != null && Platform.getModIds().contains(modId) && (paths = Platform.getMod((String)modId).getFilePaths()) != null && !paths.isEmpty()) {
            for (Path res : paths) {
                if (res.toString().isEmpty() || !Files.isRegularFile(res, new LinkOption[0])) continue;
                return res;
            }
        }
        for (Class<?> cls : clazz) {
            CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
            if (codeSource == null) continue;
            URL jarPath = codeSource.getLocation();
            String decoded = URLDecoder.decode(jarPath.getPath(), StandardCharsets.UTF_8);
            String dir = new File(decoded).getPath().replaceAll("#.+!", "").replaceAll("\\.jar.+", ".jar");
            return Paths.get(dir, new String[0]);
        }
        return null;
    }

    public static void loadResource(String modId, Class<?> ... clazz) {
        Path path = AddonLoader.classJarPath(modId, clazz);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            try (FolderPackResources packResource = Files.isDirectory(path, new LinkOption[0]) ? new FolderPackResources(path.toFile()) : new FilePackResources(path.toFile());){
                YUUSHYA_MANAGER.m_215377_((PackResources)packResource);
            }
        }
    }

    public static void loadPackResource(Path folder) {
        try (Stream<Path> files = Files.list(folder).filter(ADDON_FILTER).sorted(Comparator.comparing(Path::toString));){
            List<Path> fileList = files.toList();
            for (Path path : fileList) {
                try (FilePackResources packResource = new FilePackResources(path.toFile());){
                    YUUSHYA_MANAGER.m_215377_((PackResources)packResource);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <V> List<Map.Entry<ResourceLocation, V>> sortMapEntry(Set<Map.Entry<ResourceLocation, V>> entrySet) {
        return entrySet.stream().sorted(Comparator.comparing(a -> ((ResourceLocation)a.getKey()).m_135815_()).thenComparing(a -> ((ResourceLocation)a.getKey()).m_135827_())).toList();
    }

    public static void getRegister() {
        for (Map.Entry entry : AddonLoader.sortMapEntry(YUUSHYA_MANAGER.m_214159_("register", JSON_FILTER).entrySet())) {
            try {
                Resource resource = (Resource)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.m_215508_());){
                    JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                    YuushyaRegistryConfig.mergeYuushyaRegistryBlockClass(innerJson);
                    YuushyaRegistryData YuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
                    YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void getCollision() {
        for (Map.Entry entry : AddonLoader.sortMapEntry(YUUSHYA_MANAGER.m_214159_("collision", JSON_FILTER).entrySet())) {
            try {
                ResourceLocation file = entry.getKey();
                ResourceLocation namespaceId1 = new ResourceLocation("yuushya", file.m_135815_().substring("collision/".length(), file.m_135815_().length() - ".json".length()));
                Resource resource = (Resource)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.m_215508_());){
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    HashMap<String, VoxelShape> map = new HashMap<String, VoxelShape>();
                    for (CollisionItem.Model variant : collision.blockstates) {
                        map.put(variant.variant, CollisionFileReader.getVoxelShape(variant));
                    }
                    CollisionFileReader.getCollisionMap().put(namespaceId1.toString(), map);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, map);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

