/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;

public class CheckFileUtils {
    public static final Gson NormalGSON = new GsonBuilder().disableHtmlEscaping().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static Map<String, Info> information = new HashMap<String, Info>();
    public static final Map<String, Info> ctm = new HashMap<String, Info>();
    public static final Map<String, Info> resourcepacks = new HashMap<String, Info>();
    public static final Map<String, Info> recommend = new HashMap<String, Info>();
    private static String version;
    private static String api;
    private static final InputStream INFORMATION_FILE;
    private static final String MOD_ID_INDIUM = "indium";
    private static final String MOD_ID_SODIUM = "sodium";
    private static final String MOD_ID_YUUSHYA_MODELLING = "yuushya_modelling";
    private static final String MOD_ID_CONTINUITY = "continuity";

    public static Info info(String id) {
        return information.get(id);
    }

    public static void loadInformation() {
        version = SharedConstants.m_183709_().getName();
        String string = Platform.isFabric() ? "fabric" : (api = Platform.isForge() ? "forge" : "");
        if (INFORMATION_FILE != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(INFORMATION_FILE));){
                JsonElement jsonElement = JsonParser.parseReader((Reader)bufferedReader);
                information = (Map)NormalGSON.fromJson(jsonElement, new TypeToken<Map<String, Info>>(){}.getType());
                for (Map.Entry<String, Info> entry : information.entrySet()) {
                    Info info = entry.getValue();
                    if (!info.api.contains(api) || !info.minecraft.contains(version)) continue;
                    switch (info.type) {
                        case "ctm": {
                            ctm.put(entry.getKey(), info);
                            break;
                        }
                        case "resourcepack": {
                            resourcepacks.put(entry.getKey(), info);
                            break;
                        }
                        case "recommend": {
                            recommend.put(entry.getKey(), info);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void printInformation() {
        for (Info info : information.values()) {
            System.out.println(info);
        }
    }

    public static List<Info> checkCTM() {
        for (Info info : ctm.values()) {
            if (!CheckFileUtils.checkMod(info.id)) continue;
            return List.of();
        }
        return ctm.values().stream().toList();
    }

    public static List<Info> checkResourcePacks() {
        return resourcepacks.values().stream().filter(info -> !CheckFileUtils.checkResourceFile(info.id)).toList();
    }

    public static List<Info> checkRecommend() {
        ArrayList<Info> list = new ArrayList<Info>(recommend.values().stream().filter(info -> !MOD_ID_INDIUM.equals(info.id) && !CheckFileUtils.checkMod(info.id)).toList());
        if (Platform.isFabric() && CheckFileUtils.checkMod(MOD_ID_SODIUM) && (CheckFileUtils.checkMod(MOD_ID_YUUSHYA_MODELLING) || CheckFileUtils.checkMod(MOD_ID_CONTINUITY)) && !CheckFileUtils.checkMod(MOD_ID_INDIUM)) {
            list.add(recommend.get(MOD_ID_INDIUM));
        }
        return list;
    }

    public static boolean checkMod(String id) {
        return Platform.getModIds().contains(id);
    }

    public static boolean checkResourceFile(String id) {
        Minecraft minecraft = Minecraft.m_91087_();
        String id1 = id.replace("_", "").toLowerCase();
        for (String selectedId : minecraft.m_91099_().m_10523_()) {
            if (!selectedId.replaceAll("\\s", "").replaceAll("_", "").toLowerCase().contains(id1)) continue;
            return true;
        }
        return false;
    }

    public static int compareVersion(String version1, String version2) {
        String ver1 = version1.substring(2);
        String ver2 = version2.substring(2);
        return Double.compare(Double.parseDouble(ver1), Double.parseDouble(ver2));
    }

    public static boolean between(String version, String begin, String end) {
        if (begin == null) {
            if (end == null) {
                return true;
            }
            return CheckFileUtils.compareVersion(version, end) < 0;
        }
        if (end == null) {
            return CheckFileUtils.compareVersion(version, begin) >= 0;
        }
        return CheckFileUtils.compareVersion(version, begin) >= 0 && CheckFileUtils.compareVersion(version, end) < 0;
    }

    static {
        INFORMATION_FILE = CheckFileUtils.class.getResourceAsStream("/assets/yuushya/information/information.json");
    }

    public static final class Info {
        private final String id;
        private final String type;
        private final List<String> api;
        private final String version;
        private final List<String> minecraft;
        private final Map<String, String> link;

        public Info(String id, String type, List<String> api, String version, List<String> minecraft, Map<String, String> link) {
            this.id = id;
            this.type = type;
            this.api = api;
            this.version = version;
            this.minecraft = minecraft;
            this.link = link;
        }

        public String id() {
            return this.id;
        }

        public String type() {
            return this.type;
        }

        public List<String> api() {
            return this.api;
        }

        public String version() {
            return this.version;
        }

        public List<String> minecraft() {
            return this.minecraft;
        }

        public Map<String, String> link() {
            return this.link;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Info that = (Info)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.api, that.api) && Objects.equals(this.version, that.version) && Objects.equals(this.minecraft, that.minecraft) && Objects.equals(this.link, that.link);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.type, this.api, this.version, this.minecraft, this.link);
        }

        public String toString() {
            return "Info[id=" + this.id + ", type=" + this.type + ", api=" + String.valueOf(this.api) + ", version=" + this.version + ", minecraft=" + String.valueOf(this.minecraft) + ", link=" + String.valueOf(this.link) + "]";
        }
    }
}

