/*
 * Decompiled with CFR 0.152.
 */
package gardensofthedead.feature;

import com.mojang.serialization.Codec;
import gardensofthedead.feature.SoulSporeColumnFeature;
import gardensofthedead.feature.configuration.HugeFlatFungusConfiguration;
import gardensofthedead.registry.ModBlocks;
import net.minecraft.class_1936;
import net.minecraft.class_1945;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3031;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class HugeFlatFungusFeature
extends class_3031<HugeFlatFungusConfiguration> {
    public HugeFlatFungusFeature(Codec<HugeFlatFungusConfiguration> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<HugeFlatFungusConfiguration> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_5819 randomsource = context.method_33654();
        class_2794 chunkgenerator = context.method_33653();
        HugeFlatFungusConfiguration configuration = (HugeFlatFungusConfiguration)context.method_33656();
        class_2248 validBaseBlock = configuration.validBaseState().method_26204();
        class_2680 supportingBlock = level.method_8320(pos.method_10074());
        if (!supportingBlock.method_27852(validBaseBlock)) {
            return false;
        }
        int height = class_3532.method_15395((class_5819)randomsource, (int)4, (int)9);
        if (!configuration.planted()) {
            int maxHeight = chunkgenerator.method_12104();
            if (pos.method_10264() + height + 1 >= maxHeight) {
                return false;
            }
        }
        level.method_8652(pos, class_2246.field_10124.method_9564(), 4);
        this.placeStem(level, randomsource, configuration, pos, height);
        this.placeHat(level, randomsource, configuration, pos, height);
        return true;
    }

    private static boolean isReplaceable(class_5281 level, class_2338 pos, HugeFlatFungusConfiguration configuration, boolean isTrunk) {
        if (level.method_16358(pos, class_4970.class_4971::method_45474)) {
            return true;
        }
        return isTrunk && configuration.replaceableBlocks().test((Object)level, (Object)pos);
    }

    private void placeStem(class_5281 level, class_5819 randomSource, HugeFlatFungusConfiguration configuration, class_2338 origin, int height) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2680 stemState = configuration.stemState();
        for (int y = 0; y < height; ++y) {
            pos.method_25504((class_2382)origin, 0, y, 0);
            if (!HugeFlatFungusFeature.isReplaceable(level, (class_2338)pos, configuration, true)) continue;
            level.method_8652((class_2338)pos, stemState, 3);
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                boolean placed;
                boolean isCorner;
                if (x == 0 && z == 0) continue;
                boolean bl = isCorner = x != 0 && z != 0;
                if (!isCorner && randomSource.method_43057() <= 0.75f || isCorner && randomSource.method_43057() < 0.25f) {
                    pos.method_25504((class_2382)origin, x, -1, z);
                    if (!level.method_22347((class_2338)pos)) {
                        pos.method_10098(class_2350.field_11036);
                        placed = this.tryPlaceStem(level, pos, configuration);
                        if (!isCorner && placed && randomSource.method_43057() < 0.25f) {
                            pos.method_25504((class_2382)origin, x, 1, z);
                            this.tryPlaceStem(level, pos, configuration);
                        }
                    }
                }
                if (!(!isCorner && randomSource.method_43057() <= 0.75f) && (!isCorner || !(randomSource.method_43057() < 0.25f))) continue;
                pos.method_25504((class_2382)origin, x, height - 1, z);
                placed = this.tryPlaceStem(level, pos, configuration);
                if (height <= 4 || isCorner || !placed || !(randomSource.method_43057() < 0.25f)) continue;
                pos.method_25504((class_2382)origin, x, height - 2, z);
                this.tryPlaceStem(level, pos, configuration);
            }
        }
    }

    private boolean tryPlaceStem(class_5281 level, class_2338.class_2339 pos, HugeFlatFungusConfiguration configuration) {
        if (HugeFlatFungusFeature.isReplaceable(level, (class_2338)pos, configuration, true)) {
            if (configuration.planted() && !level.method_8320(pos.method_10074()).method_26215()) {
                level.method_22352((class_2338)pos, true);
            }
            level.method_8652((class_2338)pos, configuration.stemState(), 3);
            return true;
        }
        return false;
    }

    private void placeHat(class_5281 level, class_5819 randomSource, HugeFlatFungusConfiguration configuration, class_2338 origin, int height) {
        float wobbliness = 0.1f + randomSource.method_43057() * 0.15f;
        float wobbleAngle = randomSource.method_43057() * (float)Math.PI * 2.0f;
        float size = (6.0f + randomSource.method_43057() * 3.0f) / 2.0f;
        int maxSize = class_3532.method_15384((double)((double)size * 1.25));
        class_2338.class_2339 pos = new class_2338.class_2339();
        boolean placeGlowingSpores = randomSource.method_43057() < 0.4f;
        for (int x = -maxSize; x <= maxSize; ++x) {
            for (int z = -maxSize; z <= maxSize; ++z) {
                boolean isEdge;
                float angle = x == 0 && z == 0 ? 0.0f : (float)class_3532.method_15349((double)x, (double)z);
                float wobble = 1.0f + wobbliness * class_3532.method_15362((float)(angle - wobbleAngle));
                float r = x * x + z * z;
                if (!(class_3532.method_27285((float)wobble) * r <= class_3532.method_27285((float)size))) continue;
                boolean bl = isEdge = (double)(class_3532.method_27285((float)wobble) * r) > class_3532.method_33723((double)((double)size - 1.5));
                if (isEdge) {
                    pos.method_25504((class_2382)origin, x, height - 1, z);
                } else {
                    pos.method_25504((class_2382)origin, x, height, z);
                }
                if (!HugeFlatFungusFeature.isReplaceable(level, (class_2338)pos, configuration, false)) continue;
                if (configuration.planted() && !level.method_8320(pos.method_10074()).method_26215()) {
                    level.method_22352((class_2338)pos, true);
                }
                this.placeHatBlock(level, randomSource, configuration, pos, isEdge, placeGlowingSpores);
            }
        }
    }

    private void placeHatBlock(class_5281 level, class_5819 randomSource, HugeFlatFungusConfiguration configuration, class_2338.class_2339 pos, boolean isEdge, boolean placeGlowingSpores) {
        this.method_13153((class_1945)level, (class_2338)pos, configuration.hatState());
        float shroomlightChance = isEdge ? 0.0f : 0.05f;
        float hangingVineChance = isEdge ? 0.3f : 0.75f;
        float sproutChance = 0.2f;
        if (randomSource.method_43057() < shroomlightChance) {
            if (level.method_22347(pos.method_10074())) {
                this.method_13153((class_1945)level, pos.method_10074(), class_2246.field_22122.method_9564());
            }
        } else if (randomSource.method_43057() < hangingVineChance) {
            HugeFlatFungusFeature.tryPlaceHangingSoulSpore((class_2338)pos, (class_1936)level, randomSource, isEdge, placeGlowingSpores);
        }
        if (randomSource.method_43057() < sproutChance && level.method_22347(pos.method_10084())) {
            this.method_13153((class_1945)level, pos.method_10084(), ((class_2248)ModBlocks.SOULBLIGHT_SPROUTS.get()).method_9564());
        }
    }

    private static void tryPlaceHangingSoulSpore(class_2338 pos, class_1936 level, class_5819 randomSource, boolean isEdge, boolean placeGlowingSpores) {
        class_2338.class_2339 below = pos.method_25503().method_10098(class_2350.field_11033);
        if (level.method_22347((class_2338)below)) {
            int length = class_3532.method_15395((class_5819)randomSource, (int)2, (int)3) + (isEdge ? 0 : 1);
            SoulSporeColumnFeature.placeSoulSporeColumn(level, randomSource, below, length, class_2350.field_11033, isEdge && placeGlowingSpores ? 1.0f : 0.0f);
        }
    }
}

