/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.shieldStuns;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ShieldStuns
extends JavaPlugin {
    public void onEnable() {
        this.getLogger().info("ShieldStuns plugin is enabling...");
        if (this.modifyPaperConfig()) {
            this.getLogger().info("Successfully enabled skip-vanilla-damage-tick-when-shield-blocked!");
            this.getLogger().info("ShieldStuns plugin enabled successfully!");
        } else {
            this.getLogger().warning("Failed to modify paper-global.yml. Please check if Paper is installed and the config exists.");
        }
    }

    public void onDisable() {
        this.getLogger().info("ShieldStuns plugin disabled!");
    }

    private boolean modifyPaperConfig() {
        try {
            Object currentValue;
            Map config;
            File serverRoot = new File(".");
            File configDir = new File(serverRoot, "config");
            File paperGlobalFile = new File(configDir, "paper-global.yml");
            if (!paperGlobalFile.exists()) {
                this.getLogger().warning("paper-global.yml not found. This plugin requires Paper server.");
                return false;
            }
            Yaml yaml = new Yaml();
            try (FileInputStream fis = new FileInputStream(paperGlobalFile);){
                config = (Map)yaml.load((InputStream)fis);
            }
            if (config == null) {
                this.getLogger().severe("Failed to parse paper-global.yml");
                return false;
            }
            HashMap<String, Boolean> collisions = (HashMap<String, Boolean>)config.get("collisions");
            if (collisions == null) {
                collisions = new HashMap<String, Boolean>();
                config.put("collisions", collisions);
                this.getLogger().info("Created 'collisions' section in paper-global.yml");
            }
            if ((currentValue = collisions.get("skip-vanilla-damage-tick-when-shield-blocked")) instanceof Boolean && ((Boolean)currentValue).booleanValue()) {
                this.getLogger().info("skip-vanilla-damage-tick-when-shield-blocked is already set to true!");
                return true;
            }
            collisions.put("skip-vanilla-damage-tick-when-shield-blocked", true);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            options.setPrettyFlow(true);
            options.setIndent(2);
            Yaml outputYaml = new Yaml(options);
            try (FileWriter writer = new FileWriter(paperGlobalFile);){
                outputYaml.dump((Object)config, (Writer)writer);
            }
            this.getLogger().info("Modified paper-global.yml successfully!");
            this.getLogger().warning("Server restart required for changes to take effect!");
            return true;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error modifying paper-global.yml", e);
            return false;
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Unexpected error while modifying configuration", e);
            return false;
        }
    }
}

