package uk.co.cablepost.heli_cam.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10185;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.lwjgl.glfw.GLFW;
import uk.co.cablepost.heli_cam.mixin.CameraInvoker;

public class HeliCamClient implements ClientModInitializer {

    public static boolean PILOTING = false;
    public static boolean PLANE_MODE = false;
    public static boolean STABILISE = false;
    public static boolean UPRIGHT_ON_GROUND = true;
    public static float THRUST = 0f;
    public static float LERPED_THRUST = 0f;
    public static Quaternionf ROTATION = new Quaternionf();
    public static Quaternionf ROTATION_VELOCITY = new Quaternionf();

    private static class_304 rotateLeftKeyBinding;
    private static class_304 rotateRightKeyBinding;

    @Override
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register(
                ClientCommandManager.literal("heli_cam").executes(context -> {
                    PILOTING = !PILOTING;
                    THRUST = 0f;
                    LERPED_THRUST = 0f;
                    ROTATION = new Quaternionf();
                    ROTATION_VELOCITY = new Quaternionf();

                    if(PILOTING){
                        if (class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity) {
                            if(clientPlayerEntity.method_5854() != null || !clientPlayerEntity.method_7325()){
                                context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Must be in spectator to use"));
                                PILOTING = false;
                                return 1;
                            }
                        }
                    }

                    if(PILOTING) {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Enabled"));
                    }
                    else {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Disabled"));
                    }

                    return 1;
                })
            );

            dispatcher.register(
                ClientCommandManager.literal("heli_cam_plane_toggle").executes(context -> {
                    PLANE_MODE = !PLANE_MODE;

                    if(PLANE_MODE) {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Plane mode enabled"));
                    }
                    else {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Plane mode disabled"));
                    }

                    return 1;
                })
            );

            dispatcher.register(
                ClientCommandManager.literal("heli_cam_stabilise_toggle").executes(context -> {
                    STABILISE = !STABILISE;

                    if(STABILISE) {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Stabilise mode enabled"));
                    }
                    else {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Stabilise mode disabled"));
                    }

                    return 1;
                })
            );

            dispatcher.register(
                ClientCommandManager.literal("heli_cam_upright_on_ground_toggle").executes(context -> {
                    UPRIGHT_ON_GROUND = !UPRIGHT_ON_GROUND;

                    if(UPRIGHT_ON_GROUND) {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Upright on ground enabled"));
                    }
                    else {
                        context.getSource().sendFeedback(class_2561.method_43470("[Heli Cam] Upright on ground disabled"));
                    }

                    return 1;
                })
            );
        });

        ClientPlayConnectionEvents.JOIN.register((clientPlayNetworkHandler, packetSender, minecraftClient) -> {
            PILOTING = false;
        });

        ClientPlayConnectionEvents.DISCONNECT.register((clientPlayNetworkHandler, minecraftClient) -> {
            PILOTING = false;
        });

        ClientTickEvents.END_WORLD_TICK.register((context) -> {
            if (class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity) {
                if(clientPlayerEntity.method_5854() != null || !clientPlayerEntity.method_7325()){
                    PILOTING = false;
                }
            }
        });

        HudRenderCallback.EVENT.register((context, tickDeltaManager) -> {
            if(!PILOTING){
                return;
            }

            context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Heli Cam] Thrust: " + String.format("%.2f", THRUST * 100f) + "%"), 10, 10, 0xFFFFFFFF, true);
            //context.drawText(MinecraftClient.getInstance().textRenderer, Text.of("[Heli Cam] Lerped Thrust: " + String.format("%.2f", LERPED_THRUST * 100f) + "%"), 10, 30, 0xFFFFFFFF, true);

            if (class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity && clientPlayerEntity.field_17892 instanceof class_638 clientWorld) {
                context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163("[Heli Cam] Altitude: " + String.format("%.2f", clientPlayerEntity.method_30950(tickDeltaManager.method_60637(false)).method_10214() - clientWorld.method_8615())), 10, 20, 0xFFFFFFFF, true);
            }
        });

        WorldRenderEvents.AFTER_ENTITIES.register((worldRenderContext) -> {
            Quaternionf IDENTITY_QUATERNION = new Quaternionf().identity();

            if(PILOTING) {
                ROTATION.mul(ROTATION_VELOCITY);
                ROTATION_VELOCITY.slerp(IDENTITY_QUATERNION, 0.05f);

                if (class_310.method_1551().field_1724 instanceof class_746 clientPlayerEntity) {
                    if (clientPlayerEntity.field_36331 && UPRIGHT_ON_GROUND) {
                        Quaternionf groundRot = new Quaternionf().identity();
                        Vector3f euler = new Vector3f();
                        ROTATION.getEulerAnglesYXZ(euler);
                        groundRot.rotateY(euler.y);
                        ROTATION.slerp(groundRot, 0.05f);
                    }
                }

                if(STABILISE){
                    Quaternionf groundRot = new Quaternionf().identity();
                    Vector3f euler = new Vector3f();
                    ROTATION.getEulerAnglesYXZ(euler);
                    groundRot.rotateY(euler.y);
                    groundRot.rotateX(euler.x);
                    ROTATION.slerp(groundRot, 0.01f);
                }
            }
        });

        rotateLeftKeyBinding = KeyBindingHelper.registerKeyBinding(new class_304(
            "key.heli_cam.rotate_left",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_Q,
            "category.heli_cam"
        ));

        rotateRightKeyBinding = KeyBindingHelper.registerKeyBinding(new class_304(
            "key.heli_cam.rotate_right",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_E,
            "category.heli_cam"
        ));
    }

    public static void modifyCamera(class_4184 camera, CameraInvoker cameraInvoker, class_1297 focusedEntity, float tickDelta) {
    }

    public static void setCameraRotation(class_4184 camera) {
        camera.field_21518.set(HeliCamClient.ROTATION);
    }

    public static void doHeliMovement(class_746 player){
        //region Inputs
        class_10185 input = player.field_3913.field_54155;
        player.field_3913.method_3129();
        boolean yawLeft = rotateLeftKeyBinding.method_1434();
        boolean yawRight = rotateRightKeyBinding.method_1434();
        //endregion

        player.field_5960 = false;

        // Gravity
        if(!player.method_37908().method_8320(player.method_24515().method_10069(0, -1, 0)).method_26215()){
            player.method_5762(0, -0.005f, 0);
        }
        else if(!player.method_37908().method_8320(player.method_24515().method_10069(0, -1, 0)).method_26215()){
            player.method_5762(0, -0.01f, 0);
        }
        else if(!player.method_37908().method_8320(player.method_24515().method_10069(0, -3, 0)).method_26215()){
            player.method_5762(0, -0.02f, 0);
        }
        else if(!player.method_37908().method_8320(player.method_24515().method_10069(0, -4, 0)).method_26215()){
            player.method_5762(0, -0.03f, 0);
        }
        else if(!player.method_37908().method_8320(player.method_24515().method_10069(0, -5, 0)).method_26215()){
            player.method_5762(0, -0.04f, 0);
        }
        else {
            player.method_5762(0, -0.05f, 0);
        }

        //region Spiny thing
        if(input.comp_3163()){
            THRUST += 0.05f;
        }

        if(input.comp_3164()){
            THRUST -= 0.05f;
        }

        if(LERPED_THRUST < THRUST){
            LERPED_THRUST += 0.05f;
        }
        if(LERPED_THRUST > THRUST){
            LERPED_THRUST -= 0.008f;
        }

        THRUST = Math.clamp(THRUST, 0f, 1f);
        LERPED_THRUST = Math.clamp(LERPED_THRUST, 0f, 1f);

        Vector3f thrustVector = new Vector3f(0f, 0.075f * LERPED_THRUST, 0f);
        if(PLANE_MODE){
            thrustVector = new Vector3f(0f, 0.1f * LERPED_THRUST, -0.2f * LERPED_THRUST);
        }
        ROTATION.transform(thrustVector);
        player.method_5762(thrustVector.x, thrustVector.y, thrustVector.z);
        player.method_5762(0f, player.method_18798().method_1033() * 0.002f, 0f);
        //endregion

        if(input.comp_3159()){
            ROTATION_VELOCITY.rotateX(-0.005f);
            //ROTATION_VELOCITY.rotateZ(-0.001f);
        }
        if(input.comp_3160()){
            ROTATION_VELOCITY.rotateX(0.005f);
            //ROTATION_VELOCITY.rotateZ(0.001f);
        }

        if(input.comp_3161()){
            ROTATION_VELOCITY.rotateZ(0.005f);
        }
        if(input.comp_3162()){
            ROTATION_VELOCITY.rotateZ(-0.005f);
        }

        if(yawLeft) {
            ROTATION_VELOCITY.rotateY(0.005f);
        }

        if(yawRight) {
            ROTATION_VELOCITY.rotateY(-0.005f);
        }

        //region Add some randomness to be like turbulence
        if(!player.field_36331) {
            ROTATION_VELOCITY.rotateX((player.method_59922().method_43057() - 0.5f) * 0.0001f);
            ROTATION_VELOCITY.rotateY((player.method_59922().method_43057() - 0.5f) * 0.0001f);
            ROTATION_VELOCITY.rotateZ((player.method_59922().method_43057() - 0.5f) * 0.0001f);

            player.method_5762(
                (player.method_59922().method_43057() - 0.5f) * 0.01f,
                (player.method_59922().method_43057() - 0.5f) * 0.01f,
                (player.method_59922().method_43057() - 0.5f) * 0.01f
            );
        }
        //endregion

        player.method_18799(player.method_18798().method_1021(PLANE_MODE ? 0.92f : 0.98f));

        player.method_5784(class_1313.field_6305, player.method_18798());

        Vector3f rotEuler = new Vector3f();
        ROTATION.getEulerAnglesYXZ(rotEuler);
        player.method_36456((float)Math.toDegrees(180f - rotEuler.y - 45f));
        player.method_5847((float)Math.toDegrees(180f - rotEuler.y - 45f));
        player.method_36457((float)Math.toDegrees(-rotEuler.x));
    }

    public static void onMouseMove(double timeDelta, class_312 mouse) {
        if(!PILOTING){
            return;
        }

        var dX = mouse.field_1789;
        var dY = mouse.field_1787;

        if (mouse.field_1779.field_1690.field_1914) {
            float f = 2f;
            dX = mouse.field_1793.method_15429(mouse.field_1789 * f, timeDelta * f);
            dY = mouse.field_1782.method_15429(mouse.field_1787 * f, timeDelta * f);
        }

        if(PLANE_MODE){
            ROTATION_VELOCITY.rotateX((float) (dY * -0.0001f));
            ROTATION_VELOCITY.rotateZ((float) (dX * -0.00015f));
            ROTATION_VELOCITY.rotateY((float) (dX * -0.0001f));
        }
        else{
            ROTATION_VELOCITY.rotateX((float) (dY * -0.0001f));
            ROTATION_VELOCITY.rotateZ((float) (dX * -0.00005f));
            ROTATION_VELOCITY.rotateY((float) (dX * -0.0001f));
        }
    }
}
