package uk.co.cablepost.heli_cam.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_4184;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.cablepost.heli_cam.client.HeliCamClient;

@Mixin(class_4184.class)
public class CameraMixin {
    @Inject(method = "update(Lnet/minecraft/world/BlockView;Lnet/minecraft/entity/Entity;ZZF)V", at = @At("TAIL"))
    private void onUpdate(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        class_4184 camera = ((class_4184) (Object) this);
        CameraInvoker cameraInvoker = ((CameraInvoker) camera);

        HeliCamClient.modifyCamera(camera, cameraInvoker, focusedEntity, tickDelta);
    }

    @Inject(method = "setRotation(FF)V", at = @At("HEAD"), cancellable = true)
    private void setRotation(float yaw, float pitch, CallbackInfo ci) {
        if(!HeliCamClient.PILOTING){
            return;
        }

        class_4184 camera = ((class_4184) (Object) this);
        HeliCamClient.setCameraRotation(camera);
        ci.cancel();
    }
}
