package uk.co.cablepost.heli_cam.mixin;

import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.cablepost.heli_cam.client.HeliCamClient;

@Mixin(class_312.class)
public class MouseMixin {
    @Inject(method = "updateMouse(D)V", at = @At("HEAD"), cancellable = true)
    private void updateMouse(double timeDelta, CallbackInfo ci) {
        if(!HeliCamClient.PILOTING){
            return;
        }

        class_312 mouse = ((class_312) (Object) this);

        HeliCamClient.onMouseMove(timeDelta, mouse);

        ci.cancel();
    }
}
