/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.network.event;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.network.ChangeRecord;
import com.github.omoflop.crazypainting.network.event.PaintingChangeEvent;
import com.github.omoflop.crazypainting.network.types.ChangeKey;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.network.types.PaintingId;
import com.github.omoflop.crazypainting.state.CanvasManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

public class ServerPaintingChangeEventHandler
implements ServerPlayNetworking.PlayPayloadHandler<PaintingChangeEvent> {
    public void receive(PaintingChangeEvent packet, ServerPlayNetworking.Context ctx) {
        PaintingData data;
        class_3222 player = ctx.player();
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        UUID uuid = player.method_5667();
        if (!CanvasManager.CHANGE_IDS.containsKey(uuid)) {
            ServerPaintingChangeEventHandler.printFail(player, "Server does not have a change key initialized for this player.", new Object[0]);
            return;
        }
        if (packet.change().isEmpty()) {
            ServerPaintingChangeEventHandler.printFail(player, "Player sent no change key.", new Object[0]);
            return;
        }
        ChangeKey key = packet.change().get();
        ChangeRecord change = CanvasManager.CHANGE_IDS.get(uuid);
        if (!change.key().equals(key)) {
            ServerPaintingChangeEventHandler.printFail(player, "Change key does not match server key. Client sent: %s, Server has: %s", Arrays.toString(key.key()), Arrays.toString(change.key().key()));
            return;
        }
        PaintingId id = change.id();
        if (!id.equals((data = packet.data()).id())) {
            ServerPaintingChangeEventHandler.printFail(player, "Received two different ids. Client sent: %s, Server has: %s", data.id(), id);
            return;
        }
        try {
            CanvasManager.receive(data, server, player);
        }
        catch (IOException e) {
            ServerPaintingChangeEventHandler.printFail(player, key, id, "Encountered exception: %s", e);
        }
    }

    private static void printFail(class_3222 player, String extras, Object ... params) {
        CrazyPainting.LOGGER.log(Level.ERROR, "Failed to receive painting data from %s. Reason: %s".formatted(player.method_5477().getString(), String.format(extras, params)));
    }

    private static void printFail(class_3222 player, ChangeKey key, PaintingId id, String extras, Object ... params) {
        CrazyPainting.LOGGER.log(Level.ERROR, "Failed to receive painting data from %s. Key: '%s', Id: '%s', Reason: %s".formatted(player.method_5477().getString(), Arrays.toString(key.key()), id.value(), String.format(extras, params)));
    }
}

