/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.resources;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.client.screens.editor.BrushType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.io.Reader;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

@Environment(value=EnvType.CLIENT)
public class BrushReloadListener
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 BRUSHES_JSON = CrazyPainting.id("brushes/brushes.json");

    public class_2960 getFabricId() {
        return CrazyPainting.id("brush_reload_listener");
    }

    public void method_14491(class_3300 manager) {
        BrushType.clear();
        int categoryCount = 0;
        int brushTypeCount = 0;
        for (class_3298 resource : manager.method_14489(BRUSHES_JSON)) {
            try {
                JsonArray categories = JsonParser.parseReader((Reader)resource.method_43039()).getAsJsonArray();
                for (JsonElement element : categories) {
                    JsonObject category = element.getAsJsonObject();
                    String categoryName = category.get("category").getAsString();
                    JsonArray brushes = category.getAsJsonArray("brushes");
                    ++categoryCount;
                    for (JsonElement brush : brushes) {
                        String brushName = brush.getAsString();
                        class_2960 path = CrazyPainting.id(String.format("brushes/%s/%s.qoi", categoryName, brushName));
                        Optional brushResource = manager.method_14486(path);
                        if (brushResource.isEmpty()) {
                            CrazyPainting.LOGGER.error("Invalid brush defined in {}, no brush exists at path {}", (Object)BRUSHES_JSON.toString(), (Object)path);
                            continue;
                        }
                        BufferedImage brushImg = ImageIO.read(((class_3298)brushResource.get()).method_14482());
                        BrushType.register(categoryName, brushName, brushImg);
                        ++brushTypeCount;
                    }
                }
            }
            catch (Exception e) {
                CrazyPainting.LOGGER.error("Failed to parse {}, error: {}", (Object)BRUSHES_JSON.toString(), (Object)e);
            }
        }
        CrazyPainting.LOGGER.info("Loaded brush {} categories, and {} brushes", (Object)categoryCount, (Object)brushTypeCount);
    }
}

