/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.types;

import com.github.omoflop.crazypainting.client.ColorHelper;
import com.github.omoflop.crazypainting.client.CrazyPaintingClient;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorState;
import com.github.omoflop.crazypainting.client.texture.CanvasTexture;
import com.github.omoflop.crazypainting.content.CrazySounds;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_5819;

@Environment(value=EnvType.CLIENT)
public class DrawHelper {
    private final Stack<UndoEntry> undoHistory = new Stack();
    private final EditorState state;
    private final CanvasTexture canvasTexture;
    private final AtomicBoolean hasChanges;
    private Int2IntMap currentUndo;
    private int soundCooldown;

    public DrawHelper(EditorState state, CanvasTexture canvasTexture, AtomicBoolean hasChanges) {
        this.state = state;
        this.canvasTexture = canvasTexture;
        this.hasChanges = hasChanges;
    }

    public void useBrush(int x, int y, int color) {
        if (this.state.brushType == null) {
            return;
        }
        this.state.brushType.iteratePatternCentered(x, y, (px, py, alpha) -> {
            int drawColor;
            if (!this.canvasTexture.isPixelInBounds(px, py)) {
                return;
            }
            int i = px + py * this.canvasTexture.width;
            int n = drawColor = color == 0 ? color : ColorHelper.mix(this.canvasTexture.pixels[i], color);
            if (this.currentUndo == null || !this.currentUndo.containsKey(i)) {
                if (this.currentUndo != null) {
                    this.currentUndo.put(i, this.canvasTexture.pixels[i]);
                }
                this.canvasTexture.pixels[i] = drawColor;
                this.hasChanges.set(true);
                if (this.soundCooldown <= 0) {
                    CrazyPaintingClient.play(CrazySounds.BRUSH_USE, 0.3f, (float)class_5819.method_43047().method_39332(8, 12) / 10.0f);
                    this.soundCooldown = class_5819.method_43047().method_39332(6, 9);
                }
            }
        });
    }

    public void beginStroke() {
        if (this.state.colorPickerActive) {
            return;
        }
        this.currentUndo = new Int2IntArrayMap();
    }

    public void endStroke() {
        if (this.currentUndo == null || this.currentUndo.isEmpty()) {
            return;
        }
        System.out.println(this.currentUndo.size());
        this.undoHistory.push(new UndoEntry(this.currentUndo));
        this.currentUndo = null;
    }

    public boolean undo() {
        if (this.undoHistory.isEmpty()) {
            return false;
        }
        UndoEntry undo = this.undoHistory.pop();
        IntIterator intIterator = undo.oldColors.keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            this.canvasTexture.pixels[i] = undo.oldColors.get(i);
        }
        this.hasChanges.set(true);
        return true;
    }

    public void tick() {
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    @Environment(value=EnvType.CLIENT)
    record UndoEntry(Int2IntMap oldColors) {
    }
}

