/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.widgets;

import com.github.omoflop.crazypainting.client.CrazyPaintingClient;
import com.github.omoflop.crazypainting.client.screens.editor.BrushType;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorState;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorWidget;
import com.github.omoflop.crazypainting.client.screens.editor.types.MouseListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.Renderable;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class BrushPickerWidget
extends EditorWidget
implements Renderable,
MouseListener {
    private static final class_2561 BRUSH_SETTINGS_TEXT = class_2561.method_43471((String)"gui.crazypainting.painting_editor.brush_settings");
    private final EditorState state;
    private final class_327 textRenderer;
    private boolean leftJustDown;

    public BrushPickerWidget(EditorState state) {
        this.state = state;
        this.textRenderer = class_310.method_1551().field_1772;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        int n = this.centerX();
        int n2 = this.top();
        Objects.requireNonNull(this.textRenderer);
        context.method_27534(this.textRenderer, BRUSH_SETTINGS_TEXT, n, n2 - 9, -75715);
        int i = 0;
        for (String category : BrushType.getCategories()) {
            Objects.requireNonNull(this.textRenderer);
            if (this.drawBrushCategoryButton(context, mouseX, mouseY, category, this.x, this.y + i * 9) && this.leftJustDown && !this.state.brushCategory.equals(category)) {
                CrazyPaintingClient.click(2.0f);
                this.state.brushCategory = category;
                this.leftJustDown = false;
            }
            ++i;
        }
        i = 0;
        int size = 16;
        for (BrushType type : BrushType.getBrushes(this.state.brushCategory)) {
            if (this.drawBrushSelectButton(context, mouseX, mouseY, this.right() - 16, this.y + i * 16, 16, 16, type) && this.leftJustDown && this.state.brushType != type) {
                CrazyPaintingClient.click(1.7f);
                this.leftJustDown = false;
                this.state.brushType = type;
            }
            ++i;
        }
        this.leftJustDown = false;
    }

    private boolean drawBrushCategoryButton(class_332 context, int mouseX, int mouseY, String category, int x, int y) {
        boolean mouseHovered;
        class_5250 text = class_2561.method_43470((String)category);
        int width = this.textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(this.textRenderer);
        int height = 9;
        boolean bl = mouseHovered = x <= mouseX && y <= mouseY && x + width > mouseX && y + height > mouseY;
        if (mouseHovered) {
            context.method_25294(x, y, x + width, y + height, -6447721);
        }
        int textColor = -8337633;
        if (this.state.brushCategory.equals(category)) {
            textColor = -393218;
        }
        context.method_27535(this.textRenderer, (class_2561)text, x, y, textColor);
        return mouseHovered;
    }

    private boolean drawBrushSelectButton(class_332 context, int mouseX, int mouseY, int x, int y, int width, int height, BrushType brush) {
        int innerColor;
        boolean mouseHovered = x <= mouseX && y <= mouseY && x + width > mouseX && y + height > mouseY;
        boolean selected = this.state.brushType == brush;
        int borderColor = selected ? -393218 : -14869215;
        int n = innerColor = selected ? -8337633 : -393218;
        if (!selected && mouseHovered) {
            innerColor = -6447721;
        }
        context.method_49601(x, y, width, height, borderColor);
        context.method_25294(x + 1, y + 1, x + width - 1, y + height - 1, innerColor);
        brush.iteratePatternCentered(width / 2, height / 2, (px, py, ignored) -> context.method_25294(x + px, y + py, x + px + 1, y + py + 1, selected ? -393218 : -14869215));
        return mouseHovered;
    }

    @Override
    public boolean onMousePressed(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.leftJustDown = true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(double mouseX, double mouseY, int button) {
        return false;
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return false;
    }
}

