/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.network.c2s.handlers;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.network.c2s.RequestPaintingC2S;
import com.github.omoflop.crazypainting.network.s2c.PaintingUpdateS2C;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.state.CanvasManager;
import java.io.IOException;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class RequestPaintingServerHandler
implements ServerPlayNetworking.PlayPayloadHandler<RequestPaintingC2S> {
    public void receive(RequestPaintingC2S packet, ServerPlayNetworking.Context ctx) {
        class_3222 player = ctx.player();
        MinecraftServer server = Objects.requireNonNull(player.method_5682());
        try {
            PaintingData data = CanvasManager.load(packet.id(), server);
            if (data == null) {
                CrazyPainting.debug("Client {} requested painting id '{}' which is not saved to disk. Sending nothing.", ctx.player().method_5820(), packet.id());
            } else {
                CrazyPainting.debug("Sending client {} painting of size: {}", ctx.player().method_5820(), data.size().toString());
                ServerPlayNetworking.send((class_3222)player, (class_8710)new PaintingUpdateS2C(packet.id(), data));
            }
        }
        catch (IOException e) {
            CrazyPainting.debug("Failed to load painting from disk after player requested it... {}", e);
        }
    }
}

