/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client;

import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ColorHelper {
    public static int mix(int colorA, int colorB) {
        if (colorA == 0) {
            return colorB;
        }
        if (colorB == 0) {
            return colorA;
        }
        Color fg = new Color(colorA, true);
        Color bg = new Color(colorB, true);
        float fgA = (float)fg.getAlpha() / 255.0f;
        float fgR = (float)fg.getRed() / 255.0f;
        float fgG = (float)fg.getGreen() / 255.0f;
        float fgB = (float)fg.getBlue() / 255.0f;
        float bgA = (float)bg.getAlpha() / 255.0f;
        float bgR = (float)bg.getRed() / 255.0f;
        float bgG = (float)bg.getGreen() / 255.0f;
        float bgB = (float)bg.getBlue() / 255.0f;
        float a = 1.0f - (1.0f - fgA) * (1.0f - fgA);
        float r = bgR * bgA / a + fgR * fgA * (1.0f - bgA) / a;
        float g = bgG * bgA / a + fgG * fgA * (1.0f - bgA) / a;
        float b = bgB * bgA / a + fgB * fgA * (1.0f - bgA) / a;
        return ColorHelper.create(r, g, b, a);
    }

    public static int setOpacity(int color, float opacity) {
        Color color2 = new Color(color, true);
        return ColorHelper.create(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(opacity * 255.0f));
    }

    public static int create(Color color) {
        return ColorHelper.create(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public static int create(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int create(float r, float g, float b, float a) {
        return ColorHelper.create((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int contrast(int color) {
        Color col = new Color(color, true);
        double lum = (0.299 * (double)col.getRed() + 0.587 * (double)col.getGreen() + 0.114 * (double)col.getBlue()) / 255.0;
        if (lum > 0.5) {
            return -14869215;
        }
        return -393218;
    }

    public static int antiContrast(int color) {
        Color col = new Color(color, true);
        double lum = (0.299 * (double)col.getRed() + 0.587 * (double)col.getGreen() + 0.114 * (double)col.getBlue()) / 255.0;
        if (lum > 0.5) {
            return -393218;
        }
        return -14869215;
    }

    public static String hexString(int color) {
        Color col = new Color(color, true);
        StringBuilder sb = new StringBuilder("#");
        String r = Integer.toHexString(col.getRed());
        String g = Integer.toHexString(col.getGreen());
        String b = Integer.toHexString(col.getBlue());
        if (r.length() == 1) {
            sb.append('0');
        }
        sb.append(r);
        if (g.length() == 1) {
            sb.append('0');
        }
        sb.append(g);
        if (b.length() == 1) {
            sb.append('0');
        }
        sb.append(b);
        if (col.getAlpha() != 255) {
            String a = Integer.toHexString(col.getBlue());
            if (a.length() == 1) {
                sb.append('0');
            }
            sb.append(a);
        }
        return sb.toString();
    }
}

