/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.models;

import com.github.omoflop.crazypainting.client.compat.IrisCompat;
import com.github.omoflop.crazypainting.client.models.canvas.CanvasSpecialRenderer;
import com.github.omoflop.crazypainting.client.texture.CanvasTexture;
import com.github.omoflop.crazypainting.client.texture.CanvasTextureManager;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public final class CanvasRenderer {
    public static final class_2960 WHITE = class_2960.method_60654((String)"textures/misc/white.png");
    public static final class_2960 BACK = class_2960.method_60654((String)"textures/block/oak_planks.png");

    public static void render(@Nullable CanvasSpecialRenderer.Data data, class_811 displayContext, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_2960 textureId = WHITE;
        boolean isGui = displayContext == class_811.field_4317;
        boolean isGround = displayContext == class_811.field_4318;
        boolean glow = false;
        if (data != null) {
            glow = data.glow();
            Optional<class_2960> id = CanvasRenderer.tryGetCanvasId(data.canvasId());
            if (id.isPresent()) {
                textureId = id.get();
            }
        }
        if (isGui) {
            glow = true;
        }
        int width = data == null ? 1 : data.width();
        int height = data == null ? 1 : data.height();
        matrices.method_22903();
        CanvasRenderer.prepareForItem(matrices, isGui, displayContext, width, height);
        boolean drawBack = isGround || displayContext == class_811.field_4323 || displayContext == class_811.field_4320;
        CanvasRenderer.renderVertices(vertexConsumers, matrices, drawBack, textureId, width, height, glow, light);
        matrices.method_22909();
    }

    public static Optional<class_2960> tryGetCanvasId(int canvasId) {
        Optional<CanvasTexture> texture = CanvasTextureManager.request(canvasId);
        if (texture.isPresent() && texture.get().isReady()) {
            return Optional.of(texture.get().textureId);
        }
        return Optional.empty();
    }

    public static void renderVertices(class_4597 vertexConsumers, class_4587 matrices, boolean drawBack, class_2960 textureId, int width, int height, boolean glow, int light) {
        Matrix4f m = matrices.method_23760().method_23761();
        class_4587.class_4665 pose = matrices.method_23760();
        Vector3f normal = class_2350.field_11043.method_23955();
        class_4588 consumer = glow ? (IrisCompat.isShaderEnabled() ? vertexConsumers.getBuffer(class_1921.method_23026((class_2960)textureId)) : vertexConsumers.getBuffer(class_1921.method_23573((class_2960)textureId))) : vertexConsumers.getBuffer(class_1921.method_29379((class_2960)textureId));
        CanvasRenderer.addVertex(consumer, m, pose, 0.0f, 16 * height, -1.5f, 0.0f, 1.0f, light, normal);
        CanvasRenderer.addVertex(consumer, m, pose, 16 * width, 16 * height, -1.5f, 1.0f, 1.0f, light, normal);
        CanvasRenderer.addVertex(consumer, m, pose, 16 * width, 0.0f, -1.5f, 1.0f, 0.0f, light, normal);
        CanvasRenderer.addVertex(consumer, m, pose, 0.0f, 0.0f, -1.5f, 0.0f, 0.0f, light, normal);
        if (drawBack) {
            class_4588 back = vertexConsumers.getBuffer(class_1921.method_23572((class_2960)BACK));
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    CanvasRenderer.addVertex(back, m, pose, x * 16, y * 16, -1.4f, 0.0f, 0.0f, light, normal);
                    CanvasRenderer.addVertex(back, m, pose, x * 16 + 16, y * 16, -1.4f, 1.0f, 0.0f, light, normal);
                    CanvasRenderer.addVertex(back, m, pose, x * 16 + 16, y * 16 + 16, -1.4f, 1.0f, 1.0f, light, normal);
                    CanvasRenderer.addVertex(back, m, pose, x * 16, y * 16 + 16, -1.4f, 0.0f, 1.0f, light, normal);
                }
            }
        }
    }

    private static void addVertex(class_4588 consumer, Matrix4f m, class_4587.class_4665 pose, float x, float y, float z, float tx, float ty, int light, Vector3f normal) {
        normal = normal.mul((Matrix3fc)pose.method_23762());
        consumer.method_22918(m, x, y, z).method_39415(-1).method_22913(tx, ty).method_22922(class_4608.field_21444).method_60803(light).method_22914(normal.x, normal.y, normal.z);
    }

    public static void prepareForShield(class_4587 matrices) {
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22905(0.03125f, 0.03125f, 0.03125f);
        matrices.method_46416(-10.0f, -20.0f, -2.5f);
        matrices.method_22905(1.25f, 1.25f, 1.25f);
    }

    public static void prepareForItem(class_4587 matrices, boolean isGui, class_811 displayContext, int width, int height) {
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22905(0.03125f, 0.03125f, 0.03125f);
        matrices.method_46416(0.0f, 0.0f, -16.0f);
        if (displayContext == class_811.field_4316) {
            matrices.method_46416(-16.0f, (float)((height + 1) * 16), -26.0f);
            matrices.method_22905(2.0f, 2.0f, 2.0f);
        }
        if (isGui || displayContext == class_811.field_4319) {
            int longestSide = Math.max(width, height);
            matrices.method_46416(0.0f, -32.0f, 0.0f);
            matrices.method_22905(2.0f, 2.0f, 1.0f);
            matrices.method_22905(1.0f / (float)longestSide, 1.0f / (float)longestSide, 1.0f);
            if (width > height) {
                matrices.method_46416(0.0f, (float)((width - height) * 8), 0.0f);
            } else if (width < height) {
                matrices.method_46416((float)((height - width) * 8), 0.0f, 0.0f);
            }
        } else {
            matrices.method_46416(0.0f, 12.0f, 0.0f);
            matrices.method_46416((float)(16 - width * 8), (float)(-16 - height * 16), 0.0f);
        }
        if (IrisCompat.isShaderEnabled()) {
            matrices.method_46416(0.0f, 0.0f, -0.5f);
        }
    }
}

