/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.client.screens.AbstractPaintingScreen;
import com.github.omoflop.crazypainting.client.screens.editor.NetSync;
import com.github.omoflop.crazypainting.client.screens.editor.types.EditorState;
import com.github.omoflop.crazypainting.client.screens.editor.widgets.BrushPickerWidget;
import com.github.omoflop.crazypainting.client.screens.editor.widgets.CanvasWidget;
import com.github.omoflop.crazypainting.client.screens.editor.widgets.ColorPickerWidget;
import com.github.omoflop.crazypainting.client.screens.editor.widgets.HelpWidget;
import com.github.omoflop.crazypainting.client.screens.editor.widgets.SignWidget;
import com.github.omoflop.crazypainting.client.texture.CanvasTexture;
import com.github.omoflop.crazypainting.items.PaletteItem;
import com.github.omoflop.crazypainting.network.event.PaintingChangeEvent;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PaintingEditorScreen
extends AbstractPaintingScreen {
    public static final class_2960 EDITOR_TEXTURE_ID = CrazyPainting.id("textures/gui/editor.png");
    private static final class_2561 TITLE_PLACEHOLDER_TEXT = class_2561.method_43471((String)"gui.crazypainting.painting_editor.title");
    private final CanvasWidget canvasWidget;
    private final ColorPickerWidget colorPicker;
    private final BrushPickerWidget brushPicker;
    private final HelpWidget help;
    private final SignWidget sign;
    private final NetSync netSync;

    public PaintingEditorScreen(PaintingChangeEvent event, CanvasTexture texture, class_746 player, int easelEntityId) {
        super(TITLE_PLACEHOLDER_TEXT);
        this.field_22787 = class_310.method_1551();
        assert (this.field_22787 != null);
        AtomicBoolean hasChanges = new AtomicBoolean(false);
        this.netSync = new NetSync(texture, event.change().orElseThrow(), this::method_25419, hasChanges, easelEntityId);
        class_1799 paletteStack = player.method_6118(class_1304.field_6173);
        Collection<Object> colors = paletteStack.method_7960() || !(paletteStack.method_7909() instanceof PaletteItem) ? List.of() : PaletteItem.getColors(paletteStack);
        EditorState state = new EditorState();
        this.canvasWidget = new CanvasWidget(state, texture, hasChanges, colors);
        this.colorPicker = new ColorPickerWidget(state, colors);
        this.brushPicker = new BrushPickerWidget(state);
        this.sign = new SignWidget(state, this.netSync);
        this.help = new HelpWidget();
        this.drawDebugBoundaries = false;
    }

    protected void method_25426() {
        super.method_25426();
        this.addWidget(this.canvasWidget);
        this.addWidget(this.colorPicker);
        this.addWidget(this.brushPicker);
        this.addWidget(this.help);
        this.addWidget(this.sign);
    }

    @Override
    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
    }

    @Override
    protected void recalculateWidgetPositions(int width, int height) {
        super.recalculateWidgetPositions(width, height);
        this.canvasWidget.alignXCenter(width);
        this.canvasWidget.alignYCenter(height);
        int sideWidth = width / 10;
        int sideHeight = height / 2;
        this.colorPicker.alignXBetween(0, this.canvasWidget.x);
        this.colorPicker.x = Math.max(this.colorPicker.x, 0);
        this.colorPicker.alignYCenter(height);
        this.colorPicker.width = sideWidth;
        this.colorPicker.height = sideHeight;
        this.brushPicker.alignXBetween(this.canvasWidget.right(), width);
        this.brushPicker.x = Math.min(this.brushPicker.x, width - this.brushPicker.width);
        this.brushPicker.alignYCenter(height);
        this.brushPicker.width = sideWidth;
        this.brushPicker.height = sideHeight;
        this.help.x = 2;
        this.help.y = 2;
        this.help.width = 12;
        this.help.height = 12;
        this.sign.width = this.canvasWidget.width;
        this.sign.height = 30;
        this.sign.alignXCenter(width);
        this.sign.y = this.canvasWidget.bottom() + 2;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
    }

    @Override
    public void method_25393() {
        this.netSync.tick();
        super.method_25393();
    }

    public void method_25419() {
        super.method_25419();
        this.netSync.close();
        class_310.method_1551().field_1729.method_1612();
    }
}

