/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens.editor.types;

import com.github.omoflop.crazypainting.client.ColorHelper;
import com.github.omoflop.crazypainting.client.CrazyPaintingClient;
import com.github.omoflop.crazypainting.client.screens.editor.BrushType;
import com.github.omoflop.crazypainting.content.CrazySounds;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EditorState {
    @Nullable
    private static EditorState last;
    public int primaryColor;
    public int secondaryColor;
    public float opacity = 1.0f;
    public String brushCategory = "square";
    public BrushType brushType = BrushType.getBrush(this.brushCategory, "1x1");
    public boolean colorPickerActive;
    public boolean shortcutsEnabled = true;

    public EditorState() {
        if (last != null) {
            this.primaryColor = EditorState.last.primaryColor;
            this.secondaryColor = EditorState.last.secondaryColor;
            this.opacity = EditorState.last.opacity;
            this.brushCategory = EditorState.last.brushCategory;
            this.brushType = EditorState.last.brushType;
            this.colorPickerActive = EditorState.last.colorPickerActive;
        }
        last = this;
    }

    public void setColorPicker(boolean b) {
        if (this.colorPickerActive == b) {
            return;
        }
        CrazyPaintingClient.play(CrazySounds.COLOR_PICKER_USE, b ? 1.0f : 0.85f);
        this.colorPickerActive = b;
    }

    public int getPrimaryColor() {
        return this.primaryColor == 0 ? this.primaryColor : ColorHelper.setOpacity(this.primaryColor, this.opacity);
    }

    public int getSecondaryColor() {
        return this.secondaryColor == 0 ? this.secondaryColor : ColorHelper.setOpacity(this.secondaryColor, this.opacity);
    }
}

