/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.texture;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.client.mixin.TextureManagerAccessor;
import com.github.omoflop.crazypainting.items.CanvasItem;
import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.network.types.PaintingId;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CanvasTexture
implements AutoCloseable {
    public int[] pixels;
    public final int width;
    public final int height;
    public final class_1011 nativeImage;
    public final class_1043 glTexture;
    public final class_2960 textureId;
    private final PaintingId id;
    private final PaintingSize size;
    private boolean ready = false;
    private boolean editable;
    private boolean registered = false;
    private boolean isClosed = false;

    public CanvasTexture(CanvasItem base, int id) {
        this(base.width, base.height, id, true);
    }

    public CanvasTexture(byte canvasWidth, byte canvasHeight, int id, boolean editable) {
        this.textureId = CrazyPainting.id("canvas/" + id);
        this.id = new PaintingId(id);
        this.size = new PaintingSize(canvasWidth, canvasHeight);
        this.width = canvasWidth * 16;
        this.height = canvasHeight * 16;
        if (editable) {
            this.pixels = new int[this.width * this.height];
            Arrays.fill(this.pixels, -393218);
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("Image cannot be width or height of 0!");
        }
        this.editable = editable;
        this.nativeImage = new class_1011(this.width, this.height, true);
        this.glTexture = new class_1043(() -> ((class_2960)this.textureId).toString(), this.nativeImage);
    }

    public boolean isPixelInBounds(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void markUneditable() {
        this.editable = false;
        this.pixels = null;
    }

    public void updateTexture() {
        this.updateTexture(this.pixels);
    }

    public void updateTexture(int[] newPixels) {
        if (this.isClosed) {
            return;
        }
        if (this.width * this.height != newPixels.length) {
            System.out.println("Received invalid painting texture data");
            return;
        }
        if (!this.registered) {
            class_310.method_1551().method_1531().method_4616(this.textureId, (class_1044)this.glTexture);
            this.registered = true;
        }
        this.ready = false;
        if (this.editable) {
            this.pixels = newPixels;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int i = x + y * this.width;
                this.nativeImage.method_61941(x, y, newPixels[i]);
            }
        }
        this.upload();
    }

    private void upload() {
        this.glTexture.method_4524();
        this.ready = true;
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.glTexture.close();
        if (this.registered) {
            ((TextureManagerAccessor)class_310.method_1551().method_1531()).textures().remove(this.textureId);
            this.registered = false;
        }
        this.isClosed = true;
    }

    @Nullable
    public PaintingData toData() {
        BufferedImage img = new BufferedImage(this.width, this.height, 2);
        img.setRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "qoi", out);
            return new PaintingData(out.toByteArray(), this.size, this.id);
        }
        catch (IOException e) {
            return null;
        }
    }
}

