/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.items;

import com.github.omoflop.crazypainting.CrazyPainting;
import com.github.omoflop.crazypainting.Identifiable;
import com.github.omoflop.crazypainting.components.CanvasDataComponent;
import com.github.omoflop.crazypainting.content.CrazyComponents;
import com.github.omoflop.crazypainting.entities.CanvasEntity;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import java.util.List;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5431;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class CanvasItem
extends class_1792
implements Identifiable {
    public static final String UNTITLED = "Untitled Painting";
    public final class_2960 id;
    public final byte width;
    public final byte height;

    public CanvasItem(String registryName, byte width, byte height) {
        super(new class_1792.class_1793().method_7889(1).method_63686(Identifiable.key(registryName)).method_57349(class_9334.field_49632, (Object)new class_9290(List.of(), List.of(class_2561.method_43470((String)(width + "x" + height)).method_27692(class_124.field_1068)))).method_57349(class_9334.field_54196, (Object)class_10192.method_64202((class_1304)class_1304.field_6169).method_64209(false).method_66701(false).method_64203()));
        this.id = CrazyPainting.id(registryName);
        this.width = width;
        this.height = height;
    }

    public class_2561 method_7864(class_1799 stack) {
        String title = CanvasItem.getTitle(stack);
        if (title.equals(UNTITLED)) {
            return super.method_7864(stack);
        }
        return class_2561.method_43470((String)title);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2350 side = context.method_8038();
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_1799 usageStack = context.method_8041();
        if (CanvasItem.getCanvasId(usageStack) == -1) {
            return class_1269.field_5811;
        }
        boolean mayPlace = world.method_8320(pos).method_30368((class_1922)world, pos, side, class_5431.field_25823);
        if (!mayPlace) {
            return class_1269.field_5811;
        }
        class_1799 stack = usageStack.method_56701((class_1935)usageStack.method_7909(), 1);
        CanvasEntity entity = CanvasEntity.create(world, stack, pos.method_10081(side.method_62675()), side);
        world.method_8649((class_1297)entity);
        context.method_8041().method_57008(1, (class_1309)context.method_8036());
        return class_1269.field_5812;
    }

    public static int getCanvasId(class_1799 stack) {
        if (!stack.method_65797(CrazyComponents.CANVAS_DATA)) {
            return -1;
        }
        CanvasDataComponent component = (CanvasDataComponent)stack.method_57353().method_58694(CrazyComponents.CANVAS_DATA);
        if (component == null) {
            return -1;
        }
        return component.id();
    }

    public static int getGeneration(class_1799 stack) {
        if (!stack.method_65797(CrazyComponents.CANVAS_DATA)) {
            return -1;
        }
        CanvasDataComponent component = (CanvasDataComponent)stack.method_57353().method_58694(CrazyComponents.CANVAS_DATA);
        if (component == null) {
            return -1;
        }
        return component.generation();
    }

    public static boolean getGlow(class_1799 stack) {
        if (!stack.method_65797(CrazyComponents.CANVAS_DATA)) {
            return false;
        }
        CanvasDataComponent component = (CanvasDataComponent)stack.method_57353().method_58694(CrazyComponents.CANVAS_DATA);
        if (component == null) {
            return false;
        }
        return component.glow();
    }

    @Nullable
    public static String getSignedBy(class_1799 stack) {
        if (!stack.method_65797(CrazyComponents.CANVAS_DATA)) {
            return null;
        }
        CanvasDataComponent component = (CanvasDataComponent)stack.method_57353().method_58694(CrazyComponents.CANVAS_DATA);
        if (component == null) {
            return null;
        }
        String signedBy = component.signedBy();
        if (signedBy.isEmpty()) {
            return null;
        }
        return signedBy;
    }

    public static String getTitle(class_1799 stack) {
        if (!stack.method_65797(CrazyComponents.CANVAS_DATA)) {
            return UNTITLED;
        }
        CanvasDataComponent component = (CanvasDataComponent)stack.method_57353().method_58694(CrazyComponents.CANVAS_DATA);
        if (component == null) {
            return UNTITLED;
        }
        return component.title();
    }

    public PaintingSize getSize() {
        return new PaintingSize(this.width, this.height);
    }

    public static boolean isSigned(class_1799 heldStack) {
        return CanvasItem.getSignedBy(heldStack) != null;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }
}

