/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.network.types;

import com.github.omoflop.crazypainting.content.CrazyNetworking;
import com.github.omoflop.crazypainting.network.types.PaintingId;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_2540;

public record PaintingData(byte[] data, PaintingSize size, PaintingId id) {
    public void writeTo(class_2540 buf) {
        CrazyNetworking.writeByteArray(buf, this.data);
        this.size.writeTo(buf);
        this.id.writeTo(buf);
    }

    public static PaintingData readFrom(class_2540 buf) {
        return new PaintingData(CrazyNetworking.readByteArray(buf), PaintingSize.readFrom(buf), PaintingId.readFrom(buf));
    }

    public BufferedImage readImage() throws IOException {
        return ImageIO.read(new ByteArrayInputStream(this.data));
    }

    public int[] readPixelArray() throws IOException {
        BufferedImage img = this.readImage();
        int[] pixels = new int[this.size.width() * 16 * (this.size.height() * 16)];
        return img.getRGB(0, 0, this.size.width() * 16, this.size.height() * 16, pixels, 0, this.size.width() * 16);
    }
}

