/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens;

import com.github.omoflop.crazypainting.client.screens.editor.types.EditorWidget;
import com.github.omoflop.crazypainting.client.screens.editor.types.KeyListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.MouseListener;
import com.github.omoflop.crazypainting.client.screens.editor.types.Renderable;
import com.github.omoflop.crazypainting.client.screens.editor.types.Tickable;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractPaintingScreen
extends class_437 {
    private final List<EditorWidget> widgets = new ArrayList<EditorWidget>();
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    private final List<Tickable> tickables = new ArrayList<Tickable>();
    private final List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private final List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private int evilHack = 10;
    protected boolean drawDebugBoundaries = false;

    protected AbstractPaintingScreen(class_2561 title) {
        super(title);
    }

    protected <T extends EditorWidget> void addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof Renderable) {
            Renderable renderable = (Renderable)((Object)widget);
            this.renderables.add(renderable);
        }
        if (widget instanceof Tickable) {
            Tickable tickable = (Tickable)((Object)widget);
            this.tickables.add(tickable);
        }
        if (widget instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)((Object)widget);
            this.mouseListeners.add(mouseListener);
        }
        if (widget instanceof KeyListener) {
            KeyListener keyListener = (KeyListener)((Object)widget);
            this.keyListeners.add(keyListener);
        }
    }

    protected void removeWidget(EditorWidget widget) {
        this.widgets.remove(widget);
        if (widget instanceof Renderable) {
            Renderable renderable = (Renderable)((Object)widget);
            this.renderables.remove(renderable);
        }
        if (widget instanceof Tickable) {
            Tickable tickable = (Tickable)((Object)widget);
            this.tickables.remove(tickable);
        }
        if (widget instanceof MouseListener) {
            MouseListener mouseListener = (MouseListener)((Object)widget);
            this.mouseListeners.remove(mouseListener);
        }
        if (widget instanceof KeyListener) {
            KeyListener keyListener = (KeyListener)((Object)widget);
            this.keyListeners.remove(keyListener);
        }
    }

    protected void recalculateWidgetPositions(int width, int height) {
        for (EditorWidget widget : this.widgets) {
            widget.calculateSize(width, height);
        }
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.evilHack = 10;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        if (this.evilHack > 0) {
            this.recalculateWidgetPositions(this.field_22789, this.field_22790);
            --this.evilHack;
        }
        for (Renderable r : this.renderables) {
            r.render(context, mouseX, mouseY, deltaTicks);
        }
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        if (this.drawDebugBoundaries) {
            for (EditorWidget widget : this.widgets) {
                context.method_49601(widget.x, widget.y, widget.width, widget.height, -75715);
            }
        }
    }

    public void method_25393() {
        this.tickables.forEach(Tickable::tick);
        super.method_25393();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        for (KeyListener w : this.keyListeners) {
            if (!w.onKeyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        for (KeyListener w : this.keyListeners) {
            if (!w.onKeyReleased(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        for (KeyListener w : this.keyListeners) {
            if (!w.onCharTyped(chr, modifiers)) continue;
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (MouseListener w : this.mouseListeners) {
            if (!w.onMousePressed(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (MouseListener w : this.mouseListeners) {
            if (!w.onMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        for (MouseListener w : this.mouseListeners) {
            if (!w.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

