/*
 * Decompiled with CFR 0.152.
 */
package com.github.omoflop.crazypainting.client.screens;

import com.github.omoflop.crazypainting.network.types.PaintingData;
import com.github.omoflop.crazypainting.network.types.PaintingSize;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class PaintingViewerScreen
extends class_437 {
    private final int[] pixels;
    private final PaintingSize size;
    private final int pixelSize;
    private final String title;

    public PaintingViewerScreen(PaintingData data, String title) {
        super((class_2561)class_2561.method_43471((String)"gui.crazypainting.painting_viewer.title"));
        this.title = title;
        try {
            this.size = data.size();
            this.pixelSize = (int)Math.max(1.0f, 10.0f / (float)Math.max(this.size.width(), this.size.height()));
            this.pixels = data.readPixelArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        int widthPixels = this.size.width() * 16;
        int heightPixels = this.size.height() * 16;
        int canvasPixelX = (int)(((float)this.field_22789 / 2.0f - (float)(widthPixels * this.pixelSize) / 2.0f) / (float)this.pixelSize);
        int canvasPixelY = (int)(((float)this.field_22790 / 2.0f - (float)(heightPixels * this.pixelSize) / 2.0f) / (float)this.pixelSize);
        int canvasX = canvasPixelX * this.pixelSize;
        int canvasY = canvasPixelY * this.pixelSize;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.title), this.field_22789 / 2, 64, -75715);
        for (int i = 0; i < this.pixels.length; ++i) {
            int drawX = canvasX + i % widthPixels * this.pixelSize;
            int drawY = canvasY + i / widthPixels * this.pixelSize;
            context.method_25294(drawX, drawY, drawX + this.pixelSize, drawY + this.pixelSize, this.pixels[i]);
        }
    }
}

